/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TAINodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TAINodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.rpc.thrift.TAINodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.rpc.TSStatusCode;

public class ClusterNodeStartUtils {
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final String POSSIBLE_SOLUTIONS = " Possible solutions are as follows:\r\n";
    public static final TSStatus ACCEPT_NODE_REGISTRATION = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Accept Node registration.");
    public static final TSStatus ACCEPT_NODE_RESTART = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Accept Node restart.");

    private ClusterNodeStartUtils() {
    }

    private static TSStatus confirmClusterName(NodeType nodeType, String clusterName) {
        TSStatus status = new TSStatus();
        if (!CONF.getClusterName().equals(clusterName)) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s start. Because the ClusterName of the current %s and the target cluster are inconsistent. ClusterName of the current Node: %s, ClusterName of the target cluster: %s. Possible solutions are as follows:\r\n\t1. Change the seed_config_node parameter in %s to join the correct cluster.\n\t2. Change the cluster_name parameter in %s to match the target cluster", nodeType.getNodeType(), nodeType.getNodeType(), clusterName, CONF.getClusterName(), "iotdb-system.properties", "iotdb-system.properties"));
            return status;
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private static TSStatus rejectRegistrationBecauseConflictEndPoints(NodeType nodeType, List<TEndPoint> conflictEndPoints) {
        TSStatus status = new TSStatus();
        status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
        status.setMessage(String.format("Reject %s registration. Because the following ip:port: %s of the current %s is conflicted with other registered Nodes in the cluster. Possible solutions are as follows:\r\n\t1. Use SQL: \"show cluster details\" to find out the conflict Nodes. Remove them and retry start.\n\t2. Change the conflict ip:port configurations in %s file and retry start.", nodeType.getNodeType(), conflictEndPoints, nodeType.getNodeType(), "iotdb-system.properties"));
        return status;
    }

    public static TSStatus confirmClusterId(ConfigManager configManager) {
        TSStatus status = new TSStatus();
        String clusterId = configManager.getClusterManager().getClusterIdWithRetry(CommonDescriptor.getInstance().getConfig().getCnConnectionTimeoutInMS() / 2);
        if (clusterId == null) {
            status.setCode(TSStatusCode.GET_CLUSTER_ID_ERROR.getStatusCode()).setMessage("cluster id has not generated, please try again later");
            return status;
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public static TSStatus confirmDataNodeRegistration(TDataNodeRegisterReq req, ConfigManager configManager) {
        TSStatus status = ClusterNodeStartUtils.confirmClusterName(NodeType.DataNode, req.getClusterName());
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        List<TEndPoint> conflictEndPoints = ClusterNodeStartUtils.checkConflictTEndPointForNewDataNode(req.getDataNodeConfiguration().getLocation(), configManager.getNodeManager().getRegisteredDataNodes());
        if (!conflictEndPoints.isEmpty()) {
            return ClusterNodeStartUtils.rejectRegistrationBecauseConflictEndPoints(NodeType.DataNode, conflictEndPoints);
        }
        status = ClusterNodeStartUtils.confirmClusterId(configManager);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        return ACCEPT_NODE_REGISTRATION;
    }

    public static TSStatus confirmConfigNodeRegistration(TConfigNodeRegisterReq req, ConfigManager configManager) {
        TSStatus status = ClusterNodeStartUtils.confirmClusterName(NodeType.ConfigNode, req.getClusterParameters().getClusterName());
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        List<TEndPoint> conflictEndPoints = ClusterNodeStartUtils.checkConflictTEndPointForNewConfigNode(req.getConfigNodeLocation(), configManager.getNodeManager().getRegisteredConfigNodes());
        if (!conflictEndPoints.isEmpty()) {
            return ClusterNodeStartUtils.rejectRegistrationBecauseConflictEndPoints(NodeType.ConfigNode, conflictEndPoints);
        }
        status = ClusterNodeStartUtils.confirmClusterId(configManager);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        return ACCEPT_NODE_REGISTRATION;
    }

    public static TSStatus confirmAINodeRegistration(TAINodeRegisterReq req, ConfigManager configManager) {
        TSStatus status = ClusterNodeStartUtils.confirmClusterName(NodeType.AINode, req.getClusterName());
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        List<TEndPoint> conflictEndPoints = ClusterNodeStartUtils.checkConflictTEndPointForNewAINode(req.getAiNodeConfiguration().getLocation(), configManager.getNodeManager().getRegisteredAINodes());
        if (!conflictEndPoints.isEmpty()) {
            return ClusterNodeStartUtils.rejectRegistrationBecauseConflictEndPoints(NodeType.AINode, conflictEndPoints);
        }
        status = ClusterNodeStartUtils.confirmClusterId(configManager);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        return ACCEPT_NODE_REGISTRATION;
    }

    public static List<TEndPoint> checkConflictTEndPointForNewAINode(TAINodeLocation newAINodeLocation, List<TAINodeConfiguration> registeredAINodes) {
        HashSet<TEndPoint> conflictEndPointSet = new HashSet<TEndPoint>();
        for (TAINodeConfiguration registeredAINode : registeredAINodes) {
            TAINodeLocation registeredLocation = registeredAINode.getLocation();
            if (!registeredLocation.getInternalEndPoint().equals(newAINodeLocation.getInternalEndPoint())) continue;
            conflictEndPointSet.add(newAINodeLocation.getInternalEndPoint());
        }
        return new ArrayList<TEndPoint>(conflictEndPointSet);
    }

    public static TSStatus confirmNodeRestart(NodeType nodeType, String clusterName, String clusterId, int nodeId, Object nodeLocation, ConfigManager configManager) {
        TSStatus status = new TSStatus();
        if (!CONF.getClusterName().equals(clusterName)) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because the ClusterName of the current %s and the target cluster are inconsistent. ClusterName of the current Node: %s, ClusterName of the target cluster: %s. Possible solutions are as follows:\r\n\t1. Change the seed_config_node parameter in %s to join the correct cluster.\n\t2. Change the cluster_name parameter in %s to match the target cluster", nodeType.getNodeType(), nodeType.getNodeType(), clusterName, CONF.getClusterName(), "iotdb-system.properties", "iotdb-system.properties"));
            return status;
        }
        if (nodeId < 0) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because the nodeId of the current %s is %d. Possible solutions are as follows:\r\n\t1. Delete \"data\" dir and retry.", nodeType.getNodeType(), nodeType.getNodeType(), nodeId));
            return status;
        }
        TConfigNodeLocation matchedNodeLocation = null;
        switch (nodeType) {
            case ConfigNode: {
                if (!(nodeLocation instanceof TConfigNodeLocation)) break;
                matchedNodeLocation = ClusterNodeStartUtils.matchRegisteredConfigNode((TConfigNodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredConfigNodes());
                break;
            }
            case AINode: {
                if (!(nodeLocation instanceof TAINodeLocation)) break;
                matchedNodeLocation = ClusterNodeStartUtils.matchRegisteredAINode((TAINodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredAINodes());
                break;
            }
            default: {
                if (!(nodeLocation instanceof TDataNodeLocation)) break;
                matchedNodeLocation = ClusterNodeStartUtils.matchRegisteredDataNode((TDataNodeLocation)nodeLocation, configManager.getNodeManager().getRegisteredDataNodes());
            }
        }
        if (matchedNodeLocation == null) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because there are no corresponding %s(whose nodeId=%d) in the cluster. Possible solutions are as follows:\r\n\t1. Maybe you've already removed the current %s(whose nodeId=%d). Please delete the useless 'data' dir and retry start.", nodeType.getNodeType(), nodeType.getNodeType(), nodeId, nodeType.getNodeType(), nodeId));
            return status;
        }
        boolean acceptRestart = true;
        Set<Integer> updatedTEndPoints = null;
        switch (nodeType) {
            case ConfigNode: {
                if (!(nodeLocation instanceof TConfigNodeLocation) || (updatedTEndPoints = ClusterNodeStartUtils.checkUpdatedTEndPointOfConfigNode((TConfigNodeLocation)nodeLocation, matchedNodeLocation)).isEmpty()) break;
                acceptRestart = false;
                break;
            }
            default: {
                if (!(nodeLocation instanceof TDataNodeLocation) || (updatedTEndPoints = ClusterNodeStartUtils.checkUpdatedTEndPointOfDataNode((TDataNodeLocation)nodeLocation, (TDataNodeLocation)matchedNodeLocation)).stream().max(Integer::compare).orElse(-1) <= 0) break;
                acceptRestart = false;
            }
        }
        if (clusterId != null && !clusterId.isEmpty() && !clusterId.equals(configManager.getClusterManager().getClusterId())) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because the clusterId of the current %s and the target cluster are inconsistent. ClusterId of the current Node: %s, ClusterId of the target cluster: %s. Possible solutions are as follows:\r\n\t1. Please check if the node configuration or path is correct.", nodeType.getNodeType(), nodeType.getNodeType(), clusterId, configManager.getClusterManager().getClusterId()));
            return status;
        }
        if (!acceptRestart) {
            status.setCode(TSStatusCode.REJECT_NODE_START.getStatusCode());
            status.setMessage(String.format("Reject %s restart. Because the internal TEndPoints of this %s can't be modified. Possible solutions are as follows:\r\n\t1. Please keep the internal TEndPoints of this Node the same as before.", nodeType.getNodeType(), nodeType.getNodeType()));
            return status;
        }
        return ACCEPT_NODE_RESTART;
    }

    public static List<TEndPoint> checkConflictTEndPointForNewConfigNode(TConfigNodeLocation newConfigNodeLocation, List<TConfigNodeLocation> registeredConfigNodes) {
        HashSet<TEndPoint> conflictEndPointSet = new HashSet<TEndPoint>();
        for (TConfigNodeLocation registeredConfigNode : registeredConfigNodes) {
            if (registeredConfigNode.getInternalEndPoint().equals(newConfigNodeLocation.getInternalEndPoint())) {
                conflictEndPointSet.add(newConfigNodeLocation.getInternalEndPoint());
            }
            if (!registeredConfigNode.getConsensusEndPoint().equals(newConfigNodeLocation.getConsensusEndPoint())) continue;
            conflictEndPointSet.add(newConfigNodeLocation.getConsensusEndPoint());
        }
        return new ArrayList<TEndPoint>(conflictEndPointSet);
    }

    public static List<TEndPoint> checkConflictTEndPointForNewDataNode(TDataNodeLocation newDataNodeLocation, List<TDataNodeConfiguration> registeredDataNodes) {
        HashSet<TEndPoint> conflictEndPointSet = new HashSet<TEndPoint>();
        for (TDataNodeConfiguration registeredDataNode : registeredDataNodes) {
            TDataNodeLocation registeredLocation = registeredDataNode.getLocation();
            if (registeredLocation.getInternalEndPoint().equals(newDataNodeLocation.getInternalEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getInternalEndPoint());
            }
            if (registeredLocation.getMPPDataExchangeEndPoint().equals(newDataNodeLocation.getMPPDataExchangeEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getMPPDataExchangeEndPoint());
            }
            if (registeredLocation.getSchemaRegionConsensusEndPoint().equals(newDataNodeLocation.getSchemaRegionConsensusEndPoint())) {
                conflictEndPointSet.add(newDataNodeLocation.getSchemaRegionConsensusEndPoint());
            }
            if (!registeredLocation.getDataRegionConsensusEndPoint().equals(newDataNodeLocation.getDataRegionConsensusEndPoint())) continue;
            conflictEndPointSet.add(newDataNodeLocation.getDataRegionConsensusEndPoint());
        }
        return new ArrayList<TEndPoint>(conflictEndPointSet);
    }

    public static TConfigNodeLocation matchRegisteredConfigNode(TConfigNodeLocation configNodeLocation, List<TConfigNodeLocation> registeredConfigNodes) {
        for (TConfigNodeLocation registeredConfigNode : registeredConfigNodes) {
            if (registeredConfigNode.getConfigNodeId() != configNodeLocation.getConfigNodeId()) continue;
            return registeredConfigNode;
        }
        return null;
    }

    public static TAINodeLocation matchRegisteredAINode(TAINodeLocation aiNodeLocation, List<TAINodeConfiguration> registeredAINodes) {
        for (TAINodeConfiguration registeredAINode : registeredAINodes) {
            if (registeredAINode.getLocation().getAiNodeId() != aiNodeLocation.getAiNodeId()) continue;
            return registeredAINode.getLocation();
        }
        return null;
    }

    public static TDataNodeLocation matchRegisteredDataNode(TDataNodeLocation dataNodeLocation, List<TDataNodeConfiguration> registeredDataNodes) {
        for (TDataNodeConfiguration registeredDataNode : registeredDataNodes) {
            if (registeredDataNode.getLocation().getDataNodeId() != dataNodeLocation.getDataNodeId()) continue;
            return registeredDataNode.getLocation();
        }
        return null;
    }

    public static Set<Integer> checkUpdatedTEndPointOfConfigNode(TConfigNodeLocation restartLocation, TConfigNodeLocation recordLocation) {
        HashSet<Integer> updatedTEndPoints = new HashSet<Integer>();
        if (!recordLocation.getInternalEndPoint().equals(restartLocation.getInternalEndPoint())) {
            updatedTEndPoints.add(0);
        }
        if (!recordLocation.getConsensusEndPoint().equals(restartLocation.getConsensusEndPoint())) {
            updatedTEndPoints.add(1);
        }
        return updatedTEndPoints;
    }

    public static Set<Integer> checkUpdatedTEndPointOfDataNode(TDataNodeLocation restartLocation, TDataNodeLocation recordLocation) {
        HashSet<Integer> updatedTEndPoints = new HashSet<Integer>();
        if (!recordLocation.getClientRpcEndPoint().equals(restartLocation.getClientRpcEndPoint())) {
            updatedTEndPoints.add(0);
        }
        if (!recordLocation.getInternalEndPoint().equals(restartLocation.getInternalEndPoint())) {
            updatedTEndPoints.add(1);
        }
        if (!recordLocation.getMPPDataExchangeEndPoint().equals(restartLocation.getMPPDataExchangeEndPoint())) {
            updatedTEndPoints.add(2);
        }
        if (!recordLocation.getSchemaRegionConsensusEndPoint().equals(restartLocation.getSchemaRegionConsensusEndPoint())) {
            updatedTEndPoints.add(3);
        }
        if (!recordLocation.getDataRegionConsensusEndPoint().equals(restartLocation.getDataRegionConsensusEndPoint())) {
            updatedTEndPoints.add(4);
        }
        return updatedTEndPoints;
    }
}

