/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.util.List;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractSeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class AlignedSeriesScanOperator
extends AbstractSeriesScanOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AlignedSeriesScanOperator.class);
    private final int valueColumnCount;
    private int maxTsBlockLineNum = -1;

    public AlignedSeriesScanOperator(OperatorContext context, PlanNodeId sourceId, AlignedPath seriesPath, Ordering scanOrder, SeriesScanOptions seriesScanOptions, boolean queryAllSensors, List<TSDataType> dataTypes, int maxTsBlockLineNum) {
        this.sourceId = sourceId;
        this.operatorContext = context;
        this.seriesScanUtil = new AlignedSeriesScanUtil((PartialPath)seriesPath, scanOrder, seriesScanOptions, context.getInstanceContext(), queryAllSensors, dataTypes);
        this.valueColumnCount = seriesPath.getColumnNum();
        this.maxReturnSize = Math.min(this.maxReturnSize, (1L + (long)this.valueColumnCount) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
        this.maxTsBlockLineNum = maxTsBlockLineNum;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.maxReturnSize, (1L + (long)this.valueColumnCount) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
    }

    @Override
    protected void buildResult(TsBlock tsBlock) {
        int size = tsBlock.getPositionCount();
        TimeColumnBuilder timeColumnBuilder = this.resultTsBlockBuilder.getTimeColumnBuilder();
        TimeColumn timeColumn = tsBlock.getTimeColumn();
        for (int i = 0; i < size; ++i) {
            timeColumnBuilder.writeLong(timeColumn.getLong(i));
            this.resultTsBlockBuilder.declarePosition();
        }
        int columnSize = tsBlock.getValueColumnCount();
        for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
            this.appendOneColumn(columnIndex, tsBlock, size);
        }
    }

    private void appendOneColumn(int columnIndex, TsBlock tsBlock, int size) {
        ColumnBuilder columnBuilder = this.resultTsBlockBuilder.getColumnBuilder(columnIndex);
        Column column = tsBlock.getColumn(columnIndex);
        if (column.mayHaveNull()) {
            for (int i = 0; i < size; ++i) {
                if (column.isNull(i)) {
                    columnBuilder.appendNull();
                    continue;
                }
                columnBuilder.write(column, i);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                columnBuilder.write(column, i);
            }
        }
    }

    @Override
    public void initQueryDataSource(IQueryDataSource dataSource) {
        this.seriesScanUtil.initQueryDataSource((QueryDataSource)dataSource);
        this.resultTsBlockBuilder = new TsBlockBuilder(this.getResultDataTypes());
        this.resultTsBlockBuilder.setMaxTsBlockLineNumber(this.maxTsBlockLineNum);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.seriesScanUtil) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.sourceId) + (this.resultTsBlockBuilder == null ? 0L : this.resultTsBlockBuilder.getRetainedSizeInBytes());
    }
}

