/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.client;

import com.librato.metrics.client.AbstractMeasure;
import com.librato.metrics.client.Maps;
import com.librato.metrics.client.Sanitizer;
import java.util.Map;

public class CounterMeasure
extends AbstractMeasure {
    private String source;
    private final long value;

    public CounterMeasure(String name, long value) {
        super(name);
        this.value = value;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        Maps.putIfNotNull(map, "measure_time", this.epoch);
        Maps.putIfNotNull(map, "source", Sanitizer.LAST_PASS.apply(this.source));
        Maps.putIfNotNull(map, "value", this.value);
        return map;
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public boolean isGauge() {
        return false;
    }

    public CounterMeasure setSource(String source) {
        this.source = source;
        return this;
    }

    public CounterMeasure setPeriod(int period) {
        this.period = period;
        return this;
    }

    public CounterMeasure setMetricAttributes(Map<String, Object> attributes) {
        this.metricAttributes = attributes;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CounterMeasure that = (CounterMeasure)o;
        if (this.value != that.value) {
            return false;
        }
        return this.source != null ? this.source.equals(that.source) : that.source == null;
    }

    @Override
    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", source='").append(this.source).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }
}

