/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class TypeInference {
    @Nullable
    private final List<String> namedArguments;
    @Nullable
    private final List<DataType> typedArguments;
    private final InputTypeStrategy inputTypeStrategy;
    @Nullable
    private final TypeStrategy accumulatorTypeStrategy;
    private final TypeStrategy outputTypeStrategy;

    private TypeInference(@Nullable List<String> namedArguments, @Nullable List<DataType> typedArguments, InputTypeStrategy inputTypeStrategy, @Nullable TypeStrategy accumulatorTypeStrategy, TypeStrategy outputTypeStrategy) {
        this.namedArguments = namedArguments;
        this.typedArguments = typedArguments;
        this.inputTypeStrategy = inputTypeStrategy;
        this.accumulatorTypeStrategy = accumulatorTypeStrategy;
        this.outputTypeStrategy = outputTypeStrategy;
        if (namedArguments != null && typedArguments != null && namedArguments.size() != typedArguments.size()) {
            throw new IllegalArgumentException(String.format("Mismatch between typed arguments %d and named argument %d.", namedArguments.size(), typedArguments.size()));
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<List<String>> getNamedArguments() {
        return Optional.ofNullable(this.namedArguments);
    }

    public Optional<List<DataType>> getTypedArguments() {
        return Optional.ofNullable(this.typedArguments);
    }

    public InputTypeStrategy getInputTypeStrategy() {
        return this.inputTypeStrategy;
    }

    public Optional<TypeStrategy> getAccumulatorTypeStrategy() {
        return Optional.ofNullable(this.accumulatorTypeStrategy);
    }

    public TypeStrategy getOutputTypeStrategy() {
        return this.outputTypeStrategy;
    }

    @PublicEvolving
    public static class Builder {
        @Nullable
        private List<String> namedArguments;
        @Nullable
        private List<DataType> typedArguments;
        private InputTypeStrategy inputTypeStrategy = InputTypeStrategies.WILDCARD;
        @Nullable
        private TypeStrategy accumulatorTypeStrategy;
        @Nullable
        private TypeStrategy outputTypeStrategy;

        public Builder namedArguments(List<String> argumentNames) {
            this.namedArguments = Preconditions.checkNotNull(argumentNames, "List of argument names must not be null.");
            return this;
        }

        public Builder namedArguments(String ... argumentNames) {
            return this.namedArguments(Arrays.asList(argumentNames));
        }

        public Builder typedArguments(List<DataType> argumentTypes) {
            this.typedArguments = Preconditions.checkNotNull(argumentTypes, "List of argument types must not be null.");
            return this;
        }

        public Builder typedArguments(DataType ... argumentTypes) {
            return this.typedArguments(Arrays.asList(argumentTypes));
        }

        public Builder inputTypeStrategy(InputTypeStrategy inputTypeStrategy) {
            this.inputTypeStrategy = Preconditions.checkNotNull(inputTypeStrategy, "Input type strategy must not be null.");
            return this;
        }

        public Builder accumulatorTypeStrategy(TypeStrategy accumulatorTypeStrategy) {
            this.accumulatorTypeStrategy = Preconditions.checkNotNull(accumulatorTypeStrategy, "Accumulator type strategy must not be null.");
            return this;
        }

        public Builder outputTypeStrategy(TypeStrategy outputTypeStrategy) {
            this.outputTypeStrategy = Preconditions.checkNotNull(outputTypeStrategy, "Output type strategy must not be null.");
            return this;
        }

        public TypeInference build() {
            return new TypeInference(this.namedArguments, this.typedArguments, this.inputTypeStrategy, this.accumulatorTypeStrategy, Preconditions.checkNotNull(this.outputTypeStrategy, "Output type strategy must not be null."));
        }
    }
}

