/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterators;
import org.apache.flink.shaded.guava30.com.google.common.primitives.Ints;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.mergetree.compact.ConcatRecordReader;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.predicate.PredicateFilter;
import org.apache.flink.table.store.file.utils.RecordReaderIterator;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.source.DataSplit;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.table.source.snapshot.ContinuousDataFileSnapshotEnumerator;
import org.apache.flink.table.store.table.source.snapshot.SnapshotEnumerator;
import org.apache.flink.table.store.utils.TypeUtils;

public class TableStreamingReader {
    private final FileStoreTable table;
    private final int[] projection;
    @Nullable
    private final Predicate predicate;
    @Nullable
    private final PredicateFilter recordFilter;
    private final SnapshotEnumerator enumerator;

    public TableStreamingReader(FileStoreTable table, int[] projection, @Nullable Predicate predicate) {
        this.table = table;
        this.projection = projection;
        this.predicate = predicate;
        if (predicate != null) {
            List<String> fieldNames = table.schema().fieldNames();
            List<String> primaryKeys = table.schema().primaryKeys();
            IntUnaryOperator operator = i -> {
                int index = Ints.indexOf(projection, i);
                boolean safeFilter = primaryKeys.isEmpty() || primaryKeys.contains(fieldNames.get(i));
                return safeFilter ? index : -1;
            };
            int[] fieldIdxToProjectionIdx = IntStream.range(0, table.schema().fields().size()).map(operator).toArray();
            this.recordFilter = new PredicateFilter(TypeUtils.project(table.schema().logicalRowType(), projection), PredicateBuilder.transformFieldMapping(predicate, fieldIdxToProjectionIdx).orElse(null));
        } else {
            this.recordFilter = null;
        }
        DataTableScan scan = table.newScan();
        if (predicate != null) {
            scan.withFilter(predicate);
        }
        this.enumerator = ContinuousDataFileSnapshotEnumerator.createWithSnapshotStarting(table, scan);
    }

    @Nullable
    public Iterator<RowData> nextBatch() throws Exception {
        DataTableScan.DataFilePlan plan = this.enumerator.enumerate();
        return plan == null ? null : this.read(plan);
    }

    private Iterator<RowData> read(DataTableScan.DataFilePlan plan) throws IOException {
        TableRead read = this.table.newRead().withProjection(this.projection);
        if (this.predicate != null) {
            read.withFilter(this.predicate);
        }
        ArrayList readers = new ArrayList();
        for (DataSplit split : plan.splits) {
            readers.add(() -> read.createReader(split));
        }
        RecordReaderIterator<RowData> iterator = new RecordReaderIterator<RowData>(ConcatRecordReader.create(readers));
        if (this.recordFilter != null) {
            return Iterators.filter(iterator, this.recordFilter::test);
        }
        return iterator;
    }
}

