/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.io.IOException;
import java.io.UTFDataFormatException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentWritable;

public abstract class AbstractPagedOutputView
implements DataOutputView,
MemorySegmentWritable {
    private MemorySegment currentSegment;
    protected final int segmentSize;
    protected final int headerLength;
    private int positionInSegment;
    private byte[] utfBuffer;

    protected AbstractPagedOutputView(MemorySegment initialSegment, int segmentSize, int headerLength) {
        if (initialSegment == null) {
            throw new NullPointerException("Initial Segment may not be null");
        }
        this.segmentSize = segmentSize;
        this.headerLength = headerLength;
        this.currentSegment = initialSegment;
        this.positionInSegment = headerLength;
    }

    protected AbstractPagedOutputView(int segmentSize, int headerLength) {
        this.segmentSize = segmentSize;
        this.headerLength = headerLength;
    }

    protected abstract MemorySegment nextSegment(MemorySegment var1, int var2) throws IOException;

    public MemorySegment getCurrentSegment() {
        return this.currentSegment;
    }

    public int getCurrentPositionInSegment() {
        return this.positionInSegment;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public void advance() throws IOException {
        this.currentSegment = this.nextSegment(this.currentSegment, this.positionInSegment);
        this.positionInSegment = this.headerLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    protected void seekOutput(MemorySegment seg, int position) {
        this.currentSegment = seg;
        this.positionInSegment = position;
    }

    protected void clear() {
        this.currentSegment = null;
        this.positionInSegment = this.headerLength;
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int remaining = this.segmentSize - this.positionInSegment;
        if (remaining >= len) {
            this.currentSegment.put(this.positionInSegment, b, off, len);
            this.positionInSegment += len;
        } else {
            int toPut;
            if (remaining == 0) {
                this.advance();
                remaining = this.segmentSize - this.positionInSegment;
            }
            while (true) {
                toPut = Math.min(remaining, len);
                this.currentSegment.put(this.positionInSegment, b, off, toPut);
                off += toPut;
                if ((len -= toPut) <= 0) break;
                this.positionInSegment = this.segmentSize;
                this.advance();
                remaining = this.segmentSize - this.positionInSegment;
            }
            this.positionInSegment += toPut;
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.writeByte(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this.positionInSegment < this.segmentSize) {
            this.currentSegment.put(this.positionInSegment++, (byte)v);
        } else {
            this.advance();
            this.writeByte(v);
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.positionInSegment < this.segmentSize - 1) {
            this.currentSegment.putShortBigEndian(this.positionInSegment, (short)v);
            this.positionInSegment += 2;
        } else if (this.positionInSegment == this.segmentSize) {
            this.advance();
            this.writeShort(v);
        } else {
            this.writeByte(v >> 8);
            this.writeByte(v);
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.positionInSegment < this.segmentSize - 1) {
            this.currentSegment.putCharBigEndian(this.positionInSegment, (char)v);
            this.positionInSegment += 2;
        } else if (this.positionInSegment == this.segmentSize) {
            this.advance();
            this.writeChar(v);
        } else {
            this.writeByte(v >> 8);
            this.writeByte(v);
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.positionInSegment < this.segmentSize - 3) {
            this.currentSegment.putIntBigEndian(this.positionInSegment, v);
            this.positionInSegment += 4;
        } else if (this.positionInSegment == this.segmentSize) {
            this.advance();
            this.writeInt(v);
        } else {
            this.writeByte(v >> 24);
            this.writeByte(v >> 16);
            this.writeByte(v >> 8);
            this.writeByte(v);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.positionInSegment < this.segmentSize - 7) {
            this.currentSegment.putLongBigEndian(this.positionInSegment, v);
            this.positionInSegment += 8;
        } else if (this.positionInSegment == this.segmentSize) {
            this.advance();
            this.writeLong(v);
        } else {
            this.writeByte((int)(v >> 56));
            this.writeByte((int)(v >> 48));
            this.writeByte((int)(v >> 40));
            this.writeByte((int)(v >> 32));
            this.writeByte((int)(v >> 24));
            this.writeByte((int)(v >> 16));
            this.writeByte((int)(v >> 8));
            this.writeByte((int)v);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeByte(s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " memory");
        }
        if (this.utfBuffer == null || this.utfBuffer.length < utflen + 2) {
            this.utfBuffer = new byte[utflen + 2];
        }
        byte[] bytearr = this.utfBuffer;
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen & 0xFF);
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        this.write(bytearr, 0, utflen + 2);
    }

    @Override
    public void skipBytesToWrite(int numBytes) throws IOException {
        while (numBytes > 0) {
            int remaining = this.segmentSize - this.positionInSegment;
            if (numBytes <= remaining) {
                this.positionInSegment += numBytes;
                return;
            }
            this.positionInSegment = this.segmentSize;
            this.advance();
            numBytes -= remaining;
        }
    }

    @Override
    public void write(DataInputView source, int numBytes) throws IOException {
        while (numBytes > 0) {
            int remaining = this.segmentSize - this.positionInSegment;
            if (numBytes <= remaining) {
                this.currentSegment.put(source, this.positionInSegment, numBytes);
                this.positionInSegment += numBytes;
                return;
            }
            if (remaining > 0) {
                this.currentSegment.put(source, this.positionInSegment, remaining);
                this.positionInSegment = this.segmentSize;
                numBytes -= remaining;
            }
            this.advance();
        }
    }

    @Override
    public void write(MemorySegment segment, int off, int len) throws IOException {
        int remaining = this.segmentSize - this.positionInSegment;
        if (remaining >= len) {
            segment.copyTo(off, this.currentSegment, this.positionInSegment, len);
            this.positionInSegment += len;
        } else {
            int toPut;
            if (remaining == 0) {
                this.advance();
                remaining = this.segmentSize - this.positionInSegment;
            }
            while (true) {
                toPut = Math.min(remaining, len);
                segment.copyTo(off, this.currentSegment, this.positionInSegment, toPut);
                off += toPut;
                if ((len -= toPut) <= 0) break;
                this.positionInSegment = this.segmentSize;
                this.advance();
                remaining = this.segmentSize - this.positionInSegment;
            }
            this.positionInSegment += toPut;
        }
    }
}

