/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.sink.compactor.RecordWiseFileCompactor;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class DecoderBasedReader<T>
implements RecordWiseFileCompactor.Reader<T> {
    private final Decoder<T> decoder;

    public DecoderBasedReader(Path path, Decoder<T> decoder) throws IOException {
        this.decoder = Preconditions.checkNotNull(decoder);
        FSDataInputStream input = path.getFileSystem().open(path);
        this.decoder.open(input);
    }

    @Override
    public T read() throws IOException {
        return this.decoder.decodeNext();
    }

    @Override
    public void close() throws Exception {
        this.decoder.close();
    }

    public static class Factory<T>
    implements RecordWiseFileCompactor.Reader.Factory<T> {
        private final Decoder.Factory<T> decoderFactory;

        public Factory(Decoder.Factory<T> decoderFactory) {
            this.decoderFactory = decoderFactory;
        }

        @Override
        public DecoderBasedReader<T> createFor(Path path) throws IOException {
            return new DecoderBasedReader<T>(path, this.decoderFactory.create());
        }
    }

    public static interface Decoder<T>
    extends Serializable {
        public void open(InputStream var1) throws IOException;

        public T decodeNext() throws IOException;

        public void close() throws IOException;

        public static interface Factory<T>
        extends Serializable {
            public Decoder<T> create();
        }
    }
}

