/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.annotation.Public;

@Public
public final class TemporaryClassLoaderContext
implements AutoCloseable {
    private final Thread thread;
    private final ClassLoader originalContextClassLoader;

    public static TemporaryClassLoaderContext of(ClassLoader cl) {
        Thread t = Thread.currentThread();
        ClassLoader original = t.getContextClassLoader();
        t.setContextClassLoader(cl);
        return new TemporaryClassLoaderContext(t, original);
    }

    private TemporaryClassLoaderContext(Thread thread, ClassLoader originalContextClassLoader) {
        this.thread = thread;
        this.originalContextClassLoader = originalContextClassLoader;
    }

    @Override
    public void close() {
        this.thread.setContextClassLoader(this.originalContextClassLoader);
    }
}

