/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.assigners;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.window.CountWindow;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.internal.InternalWindowProcessFunction;

public class CountTumblingWindowAssigner
extends WindowAssigner<CountWindow> {
    private static final long serialVersionUID = -3857633557257357800L;
    private final long size;
    private transient ValueState<Long> count;

    private CountTumblingWindowAssigner(long size) {
        this.size = size;
    }

    @Override
    public void open(InternalWindowProcessFunction.Context<?, CountWindow> ctx) throws Exception {
        String descriptorName = "tumble-count-assigner";
        ValueStateDescriptor<Long> countDescriptor = new ValueStateDescriptor<Long>(descriptorName, Types.LONG);
        this.count = (ValueState)ctx.getPartitionedState(countDescriptor);
    }

    @Override
    public Collection<CountWindow> assignWindows(RowData element, long timestamp) throws IOException {
        Long countValue = this.count.value();
        long currentCount = countValue == null ? 0L : countValue;
        long id = currentCount / this.size;
        this.count.update(currentCount + 1L);
        return Collections.singleton(new CountWindow(id));
    }

    @Override
    public TypeSerializer<CountWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new CountWindow.Serializer();
    }

    @Override
    public boolean isEventTime() {
        return false;
    }

    @Override
    public String toString() {
        return "CountTumblingWindow(" + this.size + ")";
    }

    public static CountTumblingWindowAssigner of(long size) {
        return new CountTumblingWindowAssigner(size);
    }
}

