/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.FilePathFilter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;

@Internal
public class GlobFilePathFilter
extends FilePathFilter {
    private static final long serialVersionUID = 1L;
    private final List<String> includePatterns;
    private final List<String> excludePatterns;
    private transient ArrayList<PathMatcher> includeMatchers;
    private transient ArrayList<PathMatcher> excludeMatchers;

    public GlobFilePathFilter() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public GlobFilePathFilter(List<String> includePatterns, List<String> excludePatterns) {
        this.includePatterns = Preconditions.checkNotNull(includePatterns);
        this.excludePatterns = Preconditions.checkNotNull(excludePatterns);
    }

    private ArrayList<PathMatcher> buildPatterns(List<String> patterns) {
        FileSystem fileSystem = FileSystems.getDefault();
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>(patterns.size());
        for (String patternStr : patterns) {
            matchers.add(fileSystem.getPathMatcher("glob:" + patternStr));
        }
        return matchers;
    }

    @Override
    public boolean filterPath(Path filePath) {
        if (this.getIncludeMatchers().isEmpty() && this.getExcludeMatchers().isEmpty()) {
            return false;
        }
        String path = filePath.hasWindowsDrive() ? filePath.getPath().substring(1) : filePath.getPath();
        java.nio.file.Path nioPath = Paths.get(path, new String[0]);
        for (PathMatcher matcher : this.getIncludeMatchers()) {
            if (!matcher.matches(nioPath)) continue;
            return this.shouldExclude(nioPath);
        }
        return true;
    }

    private ArrayList<PathMatcher> getIncludeMatchers() {
        if (this.includeMatchers == null) {
            this.includeMatchers = this.buildPatterns(this.includePatterns);
        }
        return this.includeMatchers;
    }

    private ArrayList<PathMatcher> getExcludeMatchers() {
        if (this.excludeMatchers == null) {
            this.excludeMatchers = this.buildPatterns(this.excludePatterns);
        }
        return this.excludeMatchers;
    }

    private boolean shouldExclude(java.nio.file.Path nioPath) {
        for (PathMatcher matcher : this.getExcludeMatchers()) {
            if (!matcher.matches(nioPath)) continue;
            return true;
        }
        return false;
    }
}

