/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.store.file.utils.OffsetRowData;
import org.apache.flink.table.types.logical.RowType;

public class OffsetRowDataHashStreamPartitioner
extends StreamPartitioner<RowData> {
    private final RowType offsetRowType;
    private final int offset;
    private transient OffsetRowData offsetRowData;
    private transient RowDataSerializer serializer;

    public OffsetRowDataHashStreamPartitioner(RowType offsetRowType, int offset) {
        this.offsetRowType = offsetRowType;
        this.offset = offset;
    }

    public void setup(int numberOfChannels) {
        super.setup(numberOfChannels);
        this.offsetRowData = new OffsetRowData(this.offsetRowType.getFieldCount(), this.offset);
        this.serializer = new RowDataSerializer(this.offsetRowType);
    }

    public int selectChannel(SerializationDelegate<StreamRecord<RowData>> record) {
        RowData rowData = (RowData)((StreamRecord)record.getInstance()).getValue();
        int hash = this.serializer.toBinaryRow((RowData)this.offsetRowData.replace(rowData)).hashCode();
        return Math.abs(hash) % this.numberOfChannels;
    }

    public StreamPartitioner<RowData> copy() {
        return this;
    }

    public SubtaskStateMapper getDownstreamSubtaskStateMapper() {
        return SubtaskStateMapper.FULL;
    }

    public boolean isPointwise() {
        return false;
    }

    public String toString() {
        return "compactor-stream-partitioner";
    }
}

