/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.action;

import java.util.Arrays;
import java.util.Optional;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.store.connector.action.CompactAction;

public class FlinkActions {
    public static CompactAction compact(Path tablePath) {
        return new CompactAction(tablePath);
    }

    public static void main(String[] args) throws Exception {
        String action;
        if (args.length < 1) {
            FlinkActions.printHelp();
            System.exit(1);
        }
        if ("compact".equals(action = args[0].toLowerCase())) {
            FlinkActions.runCompact(Arrays.copyOfRange(args, 1, args.length));
        } else {
            System.err.println("Unknown action \"" + action + "\"");
            FlinkActions.printHelp();
            System.exit(1);
        }
    }

    private static void runCompact(String[] args) throws Exception {
        Optional<CompactAction> action = CompactAction.create(MultipleParameterTool.fromArgs((String[])args));
        if (action.isPresent()) {
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            action.get().build(env);
            env.execute("Compact job: " + String.join((CharSequence)" ", args));
        } else {
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage: <action> [OPTIONS]");
        System.out.println();
        System.out.println("Available actions:");
        System.out.println("  compact");
        System.out.println();
        System.out.println("For detailed options of each action, run <action> --help");
    }
}

