/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.codegen;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.ReflectionUtil;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

@GwtIncompatible(value="java.lang.reflect.*")
public class IteratingWrapperClassBuilder {
    private static final String CLASS_TEMPLATE = "package %1$s;%n%nimport com.google.common.truth.FailureStrategy;%nimport com.google.common.truth.SubjectFactory;%n%npublic class %2$sIteratingWrapper extends %2$s {%n%n  private final SubjectFactory subjectFactory;%n  private final Iterable<%3$s> data;%n%n  public %2$sIteratingWrapper(%n      FailureStrategy failureStrategy,%n      SubjectFactory<?, ?> subjectFactory,%n      Iterable<%3$s> data%n  ) {%n    super(failureStrategy, (%3$s)null);%n    this.subjectFactory = subjectFactory;%n    this.data = data;%n  }%n%n%4$s}%n";
    private static final String WRAPPER_METHOD_TEMPLATE = "  @Override %1$s %2$s %3$s(%4$s) {%n    for (%5$s item : data) {%n      %6$s subject = (%6$s)subjectFactory.getSubject(failureStrategy, item);%n      subject.%3$s(%7$s);%n    }%n  }%n";
    private static final int TARGET_TYPE_PARAMETER = 1;
    private static final String ITERATING_WRAPPER = "IteratingWrapper";
    private final SubjectFactory<?, ?> subjectFactory;
    public final String className;

    public IteratingWrapperClassBuilder(SubjectFactory<?, ?> subjectFactory) {
        this.subjectFactory = subjectFactory;
        this.className = subjectFactory.getSubjectClass().getCanonicalName() + ITERATING_WRAPPER;
    }

    public String build() {
        Class<?> subjectClass = this.subjectFactory.getSubjectClass();
        List<Method> methods = Arrays.asList(subjectClass.getMethods());
        Class<?> targetType = ReflectionUtil.typeParameter(subjectClass, 1);
        StringBuilder methodWrappers = new StringBuilder();
        for (Method m : methods) {
            this.appendMethodWrapper(methodWrappers, subjectClass, targetType, m);
        }
        String code = String.format(CLASS_TEMPLATE, subjectClass.getPackage().getName(), subjectClass.getSimpleName(), targetType.getCanonicalName(), methodWrappers.toString());
        return code;
    }

    private void appendMethodWrapper(StringBuilder code, Class<?> subjectType, Class<?> targetType, Method method) {
        boolean shouldWrap;
        int modifiers = method.getModifiers();
        boolean bl = shouldWrap = !method.getDeclaringClass().equals(Subject.class) && !method.getDeclaringClass().equals(Object.class) && !Modifier.isFinal(modifiers) && !Modifier.isPrivate(modifiers) && !Modifier.isStatic(modifiers);
        if (shouldWrap) {
            code.append(String.format(WRAPPER_METHOD_TEMPLATE, IteratingWrapperClassBuilder.stringVisibility(modifiers), method.getReturnType().getCanonicalName(), method.getName(), IteratingWrapperClassBuilder.methodSignature(method.getParameterTypes(), method.getParameterAnnotations()).toString(), targetType.getCanonicalName(), subjectType.getCanonicalName(), IteratingWrapperClassBuilder.methodParameterList(method.getParameterTypes().length)));
        }
    }

    private static StringBuilder methodParameterList(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("arg").append(0);
        }
        return builder;
    }

    private static StringBuilder methodSignature(Class<?>[] parameters, Annotation[][] annotations) {
        StringBuilder builder = new StringBuilder();
        int iLen = parameters.length;
        for (int i = 0; i < iLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            int jLen = annotations[i].length;
            for (int j = 0; j < jLen; ++j) {
                if (j > 0) {
                    builder.append(" ");
                }
                builder.append("@").append(annotations[i][j].annotationType().getCanonicalName());
                builder.append(" ");
            }
            builder.append(parameters[i].getCanonicalName());
            builder.append(" arg").append(i);
        }
        return builder;
    }

    private static String stringVisibility(int modifiers) {
        if (Modifier.isProtected(modifiers)) {
            return "protected";
        }
        if (Modifier.isPublic(modifiers)) {
            return "public";
        }
        return "";
    }
}

