/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.mxml;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.common.SourceLocation;
import org.apache.flex.compiler.internal.mxml.MXMLDialect;
import org.apache.flex.compiler.internal.parsing.ISourceFragment;
import org.apache.flex.compiler.internal.parsing.SourceFragment;
import org.apache.flex.compiler.internal.parsing.as.ASParser;
import org.apache.flex.compiler.internal.parsing.as.IncludeHandler;
import org.apache.flex.compiler.internal.parsing.as.OffsetLookup;
import org.apache.flex.compiler.internal.parsing.as.StreamingASTokenizer;
import org.apache.flex.compiler.internal.parsing.mxml.MXMLTokenizer;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.scopes.MXMLFileScope;
import org.apache.flex.compiler.internal.semantics.PostProcessStep;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLFileNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.mxml.IMXMLData;
import org.apache.flex.compiler.mxml.IMXMLNamespaceAttributeData;
import org.apache.flex.compiler.mxml.IMXMLTagAttributeData;
import org.apache.flex.compiler.mxml.IMXMLTagData;
import org.apache.flex.compiler.mxml.IMXMLTextData;
import org.apache.flex.compiler.mxml.IMXMLUnitData;
import org.apache.flex.compiler.parsing.IASToken;
import org.apache.flex.compiler.parsing.IMXMLToken;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.MXMLAttributeVersionProblem;
import org.apache.flex.compiler.problems.MXMLEmptyAttributeProblem;
import org.apache.flex.compiler.problems.MXMLOtherLanguageNamespaceProblem;
import org.apache.flex.compiler.problems.MXMLPrivateAttributeProblem;
import org.apache.flex.compiler.problems.MXMLUnexpectedAttributeProblem;
import org.apache.flex.compiler.problems.MXMLUnexpectedTagProblem;
import org.apache.flex.compiler.problems.MXMLUnexpectedTextProblem;
import org.apache.flex.compiler.problems.MXMLUnknownNamespaceProblem;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDocumentNode;
import org.apache.flex.compiler.tree.mxml.IMXMLFileNode;
import org.apache.flex.compiler.tree.mxml.IMXMLNode;
import org.apache.flex.compiler.tree.mxml.IMXMLSpecifierNode;
import org.apache.flex.utils.FilenameNormalization;

public abstract class MXMLNodeBase
extends NodeBase
implements IMXMLNode {
    private static final ThreadLocal<StreamingASTokenizer> asTokenizer = new ThreadLocal<StreamingASTokenizer>(){

        @Override
        protected StreamingASTokenizer initialValue() {
            return new StreamingASTokenizer();
        }
    };
    private static final ThreadLocal<MXMLTokenizer> mxmlTokenizer = new ThreadLocal<MXMLTokenizer>(){

        @Override
        protected MXMLTokenizer initialValue() {
            return new MXMLTokenizer();
        }
    };
    private boolean validForCodeGen = true;

    public static String resolveSourceAttributePath(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute, MXMLNodeInfo info) {
        String resolvedPath;
        String sourcePath;
        if (info != null) {
            info.hasSourceAttribute = true;
        }
        if ((sourcePath = attribute.getMXMLDialect().trim(attribute.getRawValue())).isEmpty() && builder != null) {
            MXMLEmptyAttributeProblem problem = new MXMLEmptyAttributeProblem(attribute);
            builder.addProblem(problem);
            return null;
        }
        if (new File(sourcePath).isAbsolute()) {
            resolvedPath = sourcePath;
        } else {
            String mxmlPath = attribute.getParent().getParent().getPath();
            resolvedPath = FilenameUtils.getPrefix((String)mxmlPath) + FilenameUtils.getPath((String)mxmlPath);
            resolvedPath = FilenameUtils.concat((String)resolvedPath, (String)sourcePath);
        }
        String normalizedPath = FilenameNormalization.normalize(resolvedPath);
        if (builder != null) {
            builder.getFileScope().addSourceDependency(normalizedPath);
        }
        return normalizedPath;
    }

    protected static boolean isValidASIdentifier(String identifier) {
        IASToken[] tokens = asTokenizer.get().getTokens(identifier);
        return tokens != null && tokens.length == 1 && tokens[0].getType() == 15;
    }

    protected static boolean isValidXMLTagName(String tagName) {
        String s = "<" + tagName;
        IMXMLToken[] tokens = mxmlTokenizer.get().getTokens(s + "/>");
        return tokens != null && tokens.length == 2 && tokens[0].getType() == 8 && tokens[0].getText().equals(s) && tokens[1].getType() == 5;
    }

    MXMLNodeBase(NodeBase parent) {
        this.parent = parent;
    }

    @Override
    public boolean isValidForCodeGen() {
        return this.validForCodeGen;
    }

    void markInvalidForCodeGen() {
        this.validForCodeGen = false;
    }

    protected void initializeFromTag(MXMLTreeBuilder builder, IMXMLTagData tag) {
        this.setLocation(tag);
        MXMLNodeInfo info = this.createNodeInfo(builder);
        for (IMXMLTagAttributeData attribute : tag.getAttributeDatas()) {
            this.processAttribute(builder, tag, attribute, info);
        }
        for (IMXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            this.processContentUnit(builder, tag, unit, info);
        }
        this.initializationComplete(builder, tag, info);
    }

    protected MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return null;
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeInfo info) {
        this.adjustOffsets(builder);
    }

    public void adjustOffsets(MXMLTreeBuilder builder) {
        MXMLFileScope fileScope = builder.getFileScope();
        assert (fileScope != null) : "Expected MXMLFileScope.";
        OffsetLookup offsetLookup = fileScope.getOffsetLookup();
        assert (offsetLookup != null) : "Expected OffsetLookup on file scope.";
        String path = this.getFileSpecification().getPath();
        int absoluteStart = offsetLookup.getAbsoluteOffset(path, this.getAbsoluteStart())[0];
        int absoluteEnd = offsetLookup.getAbsoluteOffset(path, this.getAbsoluteEnd())[0];
        this.setStart(absoluteStart);
        this.setEnd(absoluteEnd);
    }

    @Override
    public IASNode getChild(int i) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public IMXMLClassDefinitionNode getClassDefinitionNode() {
        return (IMXMLClassDefinitionNode)this.getAncestorOfType(IMXMLClassDefinitionNode.class);
    }

    @Override
    public IMXMLDocumentNode getDocumentNode() {
        return (IMXMLDocumentNode)this.getAncestorOfType(IMXMLDocumentNode.class);
    }

    @Override
    public IMXMLFileNode getFileNode() {
        return (IMXMLFileNode)this.getAncestorOfType(IMXMLFileNode.class);
    }

    private void processAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeInfo info) {
        if (attribute instanceof IMXMLNamespaceAttributeData) {
            this.processNamespaceAttribute(builder, tag, (IMXMLNamespaceAttributeData)attribute);
        } else if (MXMLNodeBase.isPrivateAttribute(attribute)) {
            this.processPrivateAttribute(builder, tag, attribute);
        } else {
            this.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    private void processNamespaceAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLNamespaceAttributeData attribute) {
        String attributeURI = attribute.getNamespace();
        IMXMLData mxmlData = attribute.getParent().getParent();
        String languageURI = mxmlData.getMXMLDialect().getLanguageNamespace();
        if (MXMLDialect.isLanguageNamespace(attributeURI) && !attributeURI.equals(languageURI)) {
            MXMLOtherLanguageNamespaceProblem problem = new MXMLOtherLanguageNamespaceProblem(attribute);
            builder.addProblem(problem);
        }
    }

    private static boolean isPrivateAttribute(IMXMLTagAttributeData attribute) {
        String attributeURI = attribute.getURI();
        if (attributeURI == null) {
            return false;
        }
        String tagURI = attribute.getParent().getURI();
        IMXMLData mxmlData = attribute.getParent().getParent();
        MXMLDialect mxmlDialect = mxmlData.getMXMLDialect();
        String languageURI = mxmlDialect.getLanguageNamespace();
        boolean isPrivate = false;
        if (mxmlDialect.isEqualToOrAfter(MXMLDialect.MXML_2009)) {
            isPrivate = !attributeURI.equals(languageURI) && !attributeURI.equals(tagURI);
        }
        return isPrivate;
    }

    private void processPrivateAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute) {
        MXMLPrivateAttributeProblem problem = new MXMLPrivateAttributeProblem(attribute);
        builder.addProblem(problem);
    }

    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeInfo info) {
        MXMLUnexpectedAttributeProblem problem = new MXMLUnexpectedAttributeProblem(attribute);
        builder.addProblem(problem);
    }

    private void processContentUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLUnitData unit, MXMLNodeInfo info) {
        if (unit instanceof IMXMLTagData) {
            this.processChildTag(builder, tag, (IMXMLTagData)unit, info);
        } else if (unit instanceof IMXMLTextData) {
            this.processChildTextUnit(builder, tag, (IMXMLTextData)unit, info);
        }
    }

    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeInfo info) {
        if (childTag.getURI() == null) {
            builder.addProblem(new MXMLUnknownNamespaceProblem(childTag, childTag.getPrefix()));
        } else {
            builder.addProblem(new MXMLUnexpectedTagProblem(childTag));
        }
    }

    private void processChildTextUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeInfo info) {
        switch (text.getTextType()) {
            case TEXT: 
            case WHITESPACE: 
            case CDATA: {
                if (tag.getMXMLDialect().isWhitespace(text.getCompilableText())) {
                    this.processChildWhitespaceUnit(builder, tag, text, info);
                    break;
                }
                this.processChildNonWhitespaceUnit(builder, tag, text, info);
                break;
            }
        }
    }

    protected void processChildWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeInfo info) {
    }

    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeInfo info) {
        MXMLUnexpectedTextProblem problem = new MXMLUnexpectedTextProblem(text);
        builder.addProblem(problem);
    }

    public static List<ScopedBlockNode> processUnitAsAS(MXMLTreeBuilder builder, IMXMLTagData tag, String sourcePath, ASScope containingScope, PostProcessStep buildOrReconnect, IMXMLFileNode ancestorFileNode) {
        assert (buildOrReconnect == PostProcessStep.POPULATE_SCOPE || buildOrReconnect == PostProcessStep.RECONNECT_DEFINITIONS);
        ArrayList<ScopedBlockNode> nodes = new ArrayList<ScopedBlockNode>(2);
        for (IMXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            IMXMLTextData mxmlTextData;
            if (!(unit instanceof IMXMLTextData) || (mxmlTextData = (IMXMLTextData)unit).getTextType() == IMXMLTextData.TextType.WHITESPACE) continue;
            Workspace workspace = builder.getWorkspace();
            FlexProject project = builder.getProject();
            Collection<ICompilerProblem> problems = builder.getProblems();
            IncludeHandler includeHandler = new IncludeHandler(builder.getFileSpecificationGetter());
            includeHandler.setProjectAndCompilationUnit(project, builder.getCompilationUnit());
            ScopedBlockNode node = ASParser.parseFragment2(mxmlTextData.getCompilableText(), sourcePath, mxmlTextData.getCompilableTextStart(), mxmlTextData.getCompilableTextLine() - 1, mxmlTextData.getCompilableTextColumn() - 1, problems, workspace, builder.getFileNode(), containingScope, project.getProjectConfigVariables(), EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, buildOrReconnect), true, includeHandler);
            ((MXMLFileNode)ancestorFileNode).updateIncludeTreeLastModified(includeHandler.getLastModified());
            nodes.add(node);
        }
        return nodes;
    }

    public void setLocation(String sourcePath, int start, int end, int line, int column) {
        this.setSourcePath(sourcePath);
        this.setStart(start);
        this.setEnd(end);
        this.setLine(line);
        this.setColumn(column);
    }

    public void setLocation(ISourceLocation location) {
        String sourcePath = location.getSourcePath();
        int start = location.getStart();
        int end = location.getEnd();
        int line = location.getLine();
        int column = location.getColumn();
        this.setLocation(sourcePath, start, end, line, column);
    }

    protected void setLocation(IMXMLUnitData unit) {
        IMXMLTagData startTag;
        IMXMLTagData endTag;
        String sourcePath = unit.getSourcePath();
        int start = unit.getAbsoluteStart();
        int end = unit instanceof IMXMLTagData ? ((endTag = (startTag = (IMXMLTagData)unit).findMatchingEndTag()) != null ? endTag.getAbsoluteEnd() : startTag.getAbsoluteEnd()) : unit.getAbsoluteEnd();
        int line = unit.getLine();
        int column = unit.getColumn();
        this.setLocation(sourcePath, start, end, line, column);
    }

    protected void setLocation(IMXMLTagAttributeData attribute) {
        String sourcePath = attribute.getSourcePath();
        int start = attribute.getAbsoluteStart();
        int end = attribute.getAbsoluteEnd();
        int line = attribute.getLine();
        int column = attribute.getColumn();
        this.setLocation(sourcePath, start, end, line, column);
    }

    protected void setLocation(MXMLTreeBuilder builder, List<IMXMLUnitData> units) {
        IMXMLTagData endTag;
        int n = units.size();
        IMXMLUnitData firstUnit = units.get(0);
        IMXMLUnitData lastUnit = units.get(n - 1);
        if (lastUnit instanceof IMXMLTagData && lastUnit.isOpenAndNotEmptyTag() && (endTag = ((IMXMLTagData)lastUnit).findMatchingEndTag()) != null) {
            lastUnit = endTag;
        }
        String sourcePath = firstUnit.getSourcePath();
        int start = firstUnit.getStart();
        int end = lastUnit.getEnd();
        int line = firstUnit.getLine();
        int column = firstUnit.getColumn();
        this.setLocation(sourcePath, start, end, line, column);
        this.adjustOffsets(builder);
    }

    protected void accumulateTextFragments(MXMLTreeBuilder builder, IMXMLTextData text, MXMLNodeInfo info) {
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] fragments = text.getFragments(problems);
        info.addSourceFragments(text.getSourcePath(), fragments);
    }

    protected String[] processIncludeInOrExcludeFromAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        if (mxmlDialect == MXMLDialect.MXML_2006) {
            MXMLAttributeVersionProblem problem = new MXMLAttributeVersionProblem(attribute, attribute.getName(), "2009");
            builder.addProblem(problem);
            return null;
        }
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        classNode.addStateDependentNode(builder, (IMXMLNode)this);
        return mxmlDialect.splitAndTrim(attribute.getRawValue());
    }

    protected static class MXMLNodeInfo {
        private MXMLTreeBuilder builder;
        private List<IMXMLNode> childNodeList = new ArrayList<IMXMLNode>();
        private String sourcePath;
        private List<ISourceFragment> sourceFragmentList = new ArrayList<ISourceFragment>();
        public boolean hasSourceAttribute = false;
        public boolean hasDualContent = false;
        protected Set<String> specifierSet = new HashSet<String>(0);

        public MXMLNodeInfo(MXMLTreeBuilder builder) {
            this.builder = builder;
        }

        public void addChildNode(IMXMLNode childNode) {
            this.childNodeList.add(childNode);
            if (childNode instanceof IMXMLSpecifierNode) {
                IMXMLSpecifierNode specifierNode = (IMXMLSpecifierNode)childNode;
                String suffix = specifierNode.getSuffix() != null ? specifierNode.getSuffix() : "";
                this.specifierSet.add(specifierNode.getName() + '.' + suffix);
            }
        }

        public List<IMXMLNode> getChildNodeList() {
            return this.childNodeList;
        }

        public void addSourceFragments(String sourcePath, ISourceFragment[] sourceFragments) {
            this.sourcePath = sourcePath;
            for (ISourceFragment sourceFragment : sourceFragments) {
                this.sourceFragmentList.add(sourceFragment);
            }
        }

        public void clearFragments() {
            this.sourceFragmentList.clear();
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public ISourceFragment[] getSourceFragments() {
            MXMLFileScope fileScope = this.builder.getFileScope();
            OffsetLookup offsetLookup = fileScope.getOffsetLookup();
            assert (offsetLookup != null) : "Expected OffsetLookup on FileScope.";
            for (ISourceFragment fragment : this.sourceFragmentList) {
                int physicalStart = fragment.getPhysicalStart();
                int[] absoluteOffsets = offsetLookup.getAbsoluteOffset(this.sourcePath, physicalStart);
                ((SourceFragment)fragment).setPhysicalStart(absoluteOffsets[0]);
            }
            return this.sourceFragmentList.toArray(new ISourceFragment[0]);
        }

        public SourceLocation getSourceLocation() {
            int n = this.sourceFragmentList.size();
            if (n == 0) {
                return null;
            }
            ISourceFragment firstFragment = this.sourceFragmentList.get(0);
            ISourceFragment lastFragment = this.sourceFragmentList.get(n - 1);
            int start = firstFragment.getPhysicalStart();
            int end = lastFragment.getPhysicalStart() + lastFragment.getPhysicalText().length();
            int line = firstFragment.getPhysicalLine();
            int column = firstFragment.getPhysicalColumn();
            return new SourceLocation(this.sourcePath, start, end, line, column);
        }

        public boolean hasSpecifierWithName(String name, String stateName) {
            return this.specifierSet.contains(name + '.' + stateName);
        }
    }
}

