/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.config;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flex.compiler.config.Configuration;
import org.apache.flex.compiler.config.ConfigurationInfo;
import org.apache.flex.compiler.config.ConfigurationValue;
import org.apache.flex.compiler.exceptions.ConfigurationException;
import org.apache.flex.compiler.internal.config.IConfigurationFilter;
import org.apache.flex.compiler.internal.config.annotations.ArgumentNameGenerator;
import org.apache.flex.compiler.internal.config.annotations.Arguments;
import org.apache.flex.compiler.internal.config.annotations.Config;
import org.apache.flex.compiler.internal.config.annotations.FlexOnly;
import org.apache.flex.compiler.internal.config.annotations.InfiniteArguments;
import org.apache.flex.compiler.internal.config.annotations.Mapping;
import org.apache.flex.compiler.internal.config.annotations.SoftPrerequisites;
import org.apache.flex.compiler.problems.ConfigurationProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.utils.Trace;

public final class ConfigurationBuffer {
    private final Map<String, List<ConfigurationValue>> varMap;
    private final Set<String> committed;
    private final Class<? extends Configuration> configClass;
    private Map<String, ConfigurationInfo> varCache = new HashMap<String, ConfigurationInfo>();
    private List<String> requiredList = new LinkedList<String>();
    private List<String> varList = new LinkedList<String>();
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, String> tokens = new HashMap<String, String>();
    private List<Object[]> positions = new ArrayList<Object[]>();
    private static final String SET_PREFIX = "cfg";
    private static final String GET_PREFIX = "get";
    private static final String INFO_SUFFIX = "Info";
    private static final ImmutableList<String> CONVERT_FROM = ImmutableList.of((Object)"compiler-fonts-languages-", (Object)"compiler-fonts-", (Object)"compiler-namespaces-", (Object)"compiler-mxml-", (Object)"compiler-", (Object)"metadata-", (Object)"licenses-", (Object)"frames-", (Object)"runtime-shared-library-settings-");
    private static final ImmutableList<String> CONVERT_TO = ImmutableList.of((Object)"compiler.fonts.languages.", (Object)"compiler.fonts.", (Object)"compiler.namespaces.", (Object)"compiler.mxml.", (Object)"compiler.", (Object)"metadata.", (Object)"licenses.", (Object)"frames.", (Object)"runtime-shared-library-settings.");

    public ConfigurationBuffer(Class<? extends Configuration> configClass) {
        this(configClass, new HashMap<String, String>());
    }

    public ConfigurationBuffer(Class<? extends Configuration> configClass, Map<String, String> aliases) {
        this(configClass, aliases, null);
    }

    public ConfigurationBuffer(Class<? extends Configuration> configClass, Map<String, String> aliases, IConfigurationFilter filter) {
        this.configClass = configClass;
        this.varMap = new HashMap<String, List<ConfigurationValue>>();
        this.committed = new HashSet<String>();
        this.loadCache(configClass, filter);
        assert (this.varCache.size() > 0) : "coding error: nothing was configurable in the provided object!";
        for (Map.Entry<String, String> e : aliases.entrySet()) {
            this.addAlias(e.getKey(), e.getValue());
        }
    }

    public ConfigurationBuffer(ConfigurationBuffer copyFrom, boolean copyCommitted) {
        this.configClass = copyFrom.configClass;
        this.varMap = new HashMap<String, List<ConfigurationValue>>(copyFrom.varMap);
        this.committed = copyCommitted ? new HashSet<String>(copyFrom.committed) : new HashSet();
        this.varCache = copyFrom.varCache;
        this.varList = copyFrom.varList;
        this.tokens = new HashMap<String, String>(copyFrom.tokens);
    }

    public final List<String> dump() {
        ArrayList<String> dump = new ArrayList<String>(this.varCache.size());
        for (Map.Entry<String, ConfigurationInfo> entry : this.varCache.entrySet()) {
            dump.add(entry.getKey() + "," + entry.getValue().toString());
        }
        Collections.sort(dump);
        return dump;
    }

    public void setVar(String var, String val, String source, int line) throws ConfigurationException {
        LinkedList<String> list = new LinkedList<String>();
        list.add(val);
        this.setVar(var, list, source, line, null, false);
    }

    public void setVar(String var, List<String> vals, String source, int line) throws ConfigurationException {
        this.setVar(var, vals, source, line, null, false);
    }

    public void setVar(String avar, List<String> vals, String source, int line, String contextPath, boolean append) throws ConfigurationException {
        String var = this.unalias(avar);
        if (!this.isValidVar(var)) {
            throw new ConfigurationException.UnknownVariable(var, source, line);
        }
        int argCount = this.getVarArgCount(var);
        if (argCount != -1) {
            this.addAnyDefaultArgValues(var, argCount, vals);
            if (vals.size() != argCount) {
                throw new ConfigurationException.IncorrectArgumentCount(argCount, vals.size(), var, source, line);
            }
        }
        ConfigurationValue val = new ConfigurationValue(this, var, vals, source, line, contextPath);
        this.storeValue(var, val, append);
        this.committed.remove(var);
    }

    public void clearVar(String avar, String source, int line) throws ConfigurationException {
        String var = this.unalias(avar);
        if (!this.isValidVar(var)) {
            throw new ConfigurationException.UnknownVariable(var, source, line);
        }
        this.varMap.remove(var);
        this.committed.remove(var);
    }

    public void clearSourceVars(String source) {
        LinkedList<String> remove = new LinkedList<String>();
        for (Map.Entry<String, List<ConfigurationValue>> e : this.varMap.entrySet()) {
            String var = e.getKey();
            List<ConfigurationValue> vals = e.getValue();
            LinkedList<ConfigurationValue> newvals = new LinkedList<ConfigurationValue>();
            for (ConfigurationValue val : vals) {
                if (val.getSource().equals(source)) continue;
                newvals.add(val);
            }
            if (newvals.size() > 0) {
                this.varMap.put(var, newvals);
                continue;
            }
            remove.add(var);
        }
        Iterator it = remove.iterator();
        while (it.hasNext()) {
            this.varMap.remove(it.next());
        }
    }

    public List<String> processValues(String var, List<String> args, String source, int line) throws ConfigurationException {
        LinkedList<String> newArgs = new LinkedList<String>();
        for (String arg : args) {
            int o;
            int depth = 100;
            while (depth-- > 0 && (o = arg.indexOf("${")) != -1) {
                int c = arg.indexOf("}", o);
                if (c == -1) {
                    throw new ConfigurationException.Token("MissingDelimiter", null, var, source, line);
                }
                String token = arg.substring(o + 2, c);
                String value = this.getToken(token);
                if (value == null && value == null) {
                    throw new ConfigurationException.Token("UnknownToken", token, var, source, line);
                }
                arg = arg.substring(0, o) + value + arg.substring(c + 1);
            }
            if (depth == 0) {
                throw new ConfigurationException.Token("RecursionLimit", null, var, source, line);
            }
            newArgs.add(arg);
        }
        return newArgs;
    }

    public void setToken(String token, String value) {
        this.tokens.put(token, value);
    }

    public String getToken(String token) {
        if (this.tokens.containsKey(token)) {
            return this.tokens.get(token);
        }
        try {
            return System.getProperty(token);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private void storeValue(String avar, ConfigurationValue val, boolean append) throws ConfigurationException {
        List<Object> vals;
        String var = this.unalias(avar);
        ConfigurationInfo info = this.getInfo(var);
        if (this.varMap.containsKey(var)) {
            vals = this.varMap.get(var);
            assert (vals.size() > 0);
            ConfigurationValue first = (ConfigurationValue)vals.get(0);
            if (!append && !first.getSource().equals(val.getSource())) {
                vals.clear();
            } else if (!info.allowMultiple()) {
                throw new ConfigurationException.IllegalMultipleSet(var, val.getSource(), val.getLine());
            }
        } else {
            vals = new LinkedList();
            this.varMap.put(var, vals);
        }
        vals.add(val);
    }

    public List<ConfigurationValue> getVar(String avar) {
        String var = this.unalias(avar);
        return this.varMap.get(var);
    }

    public Set<String> getVars() {
        return this.varCache.keySet();
    }

    public void merge(ConfigurationBuffer other) {
        assert (this.configClass == other.configClass);
        this.varMap.putAll(other.varMap);
        this.committed.addAll(other.committed);
    }

    protected static String c2h(String camel) {
        StringBuilder b = new StringBuilder(camel.length() + 5);
        for (int i = 0; i < camel.length(); ++i) {
            char c = camel.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i != 0) {
                    b.append('-');
                }
                b.append(Character.toLowerCase(c));
                continue;
            }
            b.append(camel.charAt(i));
        }
        String combined = b.toString();
        for (int i = 0; i < CONVERT_FROM.size(); ++i) {
            if (!combined.startsWith((String)CONVERT_FROM.get(i))) continue;
            return combined.replaceFirst((String)CONVERT_FROM.get(i), (String)CONVERT_TO.get(i));
        }
        return combined;
    }

    protected static String h2c(String hyphenated, boolean studly) {
        StringBuilder b = new StringBuilder(hyphenated.length());
        boolean capNext = studly;
        for (int i = 0; i < hyphenated.length(); ++i) {
            char c = hyphenated.charAt(i);
            if (c == '-') {
                capNext = true;
                continue;
            }
            b.append(capNext ? Character.toUpperCase(c) : c);
            capNext = false;
        }
        return b.toString();
    }

    public static String varname(String membername, String basename) {
        return basename == null ? membername : basename + "." + membername;
    }

    private static ConfigurationInfo createInfo(Method setterMethod) {
        ConfigurationInfo info = null;
        String infoMethodName = GET_PREFIX + setterMethod.getName().substring(SET_PREFIX.length()) + INFO_SUFFIX;
        String getterMethodName = GET_PREFIX + setterMethod.getName().substring(SET_PREFIX.length());
        Class<?> cfgClass = setterMethod.getDeclaringClass();
        Method infoMethod = null;
        Method getterMethod = null;
        if (!setterMethod.isAnnotationPresent(Config.class)) {
            try {
                infoMethod = cfgClass.getMethod(infoMethodName, new Class[0]);
                if (!Modifier.isStatic(infoMethod.getModifiers())) {
                    assert (false) : "coding error: " + cfgClass.getName() + "." + infoMethodName + " needs to be static!";
                    infoMethod = null;
                }
                info = (ConfigurationInfo)infoMethod.invoke(null, (Object[])null);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (info == null) {
            info = new ConfigurationInfo();
        }
        try {
            getterMethod = cfgClass.getMethod(getterMethodName, null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        info.setSetterMethod(setterMethod);
        info.setGetterMethod(getterMethod);
        return info;
    }

    private boolean loadCache(Class<? extends Configuration> cfg, IConfigurationFilter filter) {
        int count = 0;
        for (Method method : cfg.getMethods()) {
            if (!method.getName().startsWith(SET_PREFIX) && !method.isAnnotationPresent(Config.class)) continue;
            String configName = null;
            Class<?>[] pt = method.getParameterTypes();
            assert (pt.length > 1) : "Expected at least one parameters on setter.";
            ConfigurationInfo info = ConfigurationBuffer.createInfo(method);
            Config config = method.getAnnotation(Config.class);
            if (config != null) {
                FlexOnly flexOnly;
                Mapping mapping;
                SoftPrerequisites softPre;
                info.isAdvanced = config.advanced();
                info.isHidden = config.hidden();
                info.isRemoved = config.removed();
                info.allowMultiple = config.allowMultiple();
                info.isPath = config.isPath();
                info.isDisplayed = config.displayed();
                info.isCompcOnly = config.compcOnly();
                info.isRequired = config.isRequired();
                ArgumentNameGenerator argumentNameGeneratorClass = method.getAnnotation(ArgumentNameGenerator.class);
                if (argumentNameGeneratorClass != null) {
                    info.argNameGeneratorClass = argumentNameGeneratorClass.value();
                } else {
                    Arguments arguments = method.getAnnotation(Arguments.class);
                    if (arguments != null) {
                        info.argnames = arguments.value();
                    }
                }
                InfiniteArguments infinite = method.getAnnotation(InfiniteArguments.class);
                if (infinite != null) {
                    info.argcount = -1;
                }
                if ((softPre = method.getAnnotation(SoftPrerequisites.class)) != null) {
                    info.softPrerequisites = softPre.value();
                }
                if ((mapping = method.getAnnotation(Mapping.class)) != null) {
                    configName = Joiner.on((String)".").skipNulls().join((Object[])mapping.value());
                }
                if ((flexOnly = method.getAnnotation(FlexOnly.class)) != null) {
                    info.isFlexOnly = true;
                }
            }
            if (configName == null) {
                configName = ConfigurationBuffer.c2h(method.getName().substring(SET_PREFIX.length()));
            }
            if (filter != null && !filter.select(configName)) continue;
            this.varCache.put(configName, info);
            this.varList.add(configName);
            if (info.isRequired()) {
                this.requiredList.add(configName);
            }
            ++count;
        }
        assert (count > 0 || filter != null) : "coding error: config class " + cfg.getName() + " did not define any setters or child configs";
        return count > 0;
    }

    String classToArgName(Class<?> c) {
        String className = c.getName();
        if (className.startsWith("java.lang.")) {
            className = className.substring("java.lang.".length());
        }
        return className.toLowerCase();
    }

    public ConfigurationInfo getInfo(String avar) {
        String var = this.unalias(avar);
        return this.varCache.get(var);
    }

    public String getVarArgName(String avar, int argnum) {
        String var = this.unalias(avar);
        ConfigurationInfo info = this.getInfo(var);
        if (info == null) assert (false) : "must call isValid to check vars!";
        return info.getArgName(argnum);
    }

    public boolean isValidVar(String avar) {
        String var = this.unalias(avar);
        ConfigurationInfo info = this.getInfo(var);
        return info != null;
    }

    public int getVarArgCount(String avar) {
        ConfigurationInfo info = this.getInfo(avar);
        assert (info != null);
        return info.getArgCount();
    }

    private void addAnyDefaultArgValues(String avar, int argCount, List<String> vals) {
        int defaultArgsStart;
        ConfigurationInfo info = this.getInfo(avar);
        int missingArgsCount = argCount - vals.size();
        if (missingArgsCount == 0 || info.getDefaultArgValues() == null) {
            return;
        }
        String[] defaultArgValues = info.getDefaultArgValues();
        int defaultArgsCount = defaultArgValues.length;
        for (int i = defaultArgsStart = defaultArgsCount - missingArgsCount; i < defaultArgsCount; ++i) {
            vals.add(defaultArgValues[i]);
        }
    }

    public boolean commit(Object config, Collection<ICompilerProblem> problems) {
        assert (config.getClass() == this.configClass) : "coding error: configuration " + config.getClass() + " != template " + this.configClass;
        HashSet<String> done = new HashSet<String>();
        boolean success = true;
        for (String var : this.varList) {
            if (!this.varMap.containsKey(var)) continue;
            try {
                this.commitVariable(config, var, done);
            }
            catch (ConfigurationException e) {
                problems.add(new ConfigurationProblem(e));
                success = false;
            }
        }
        for (String req : this.requiredList) {
            if (this.committed.contains(req)) continue;
            ConfigurationException.MissingRequirement e = new ConfigurationException.MissingRequirement(req, null, null, -1);
            problems.add(new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage()));
            success = false;
        }
        return success;
    }

    private void commitVariable(Object config, String var, Set<String> done) throws ConfigurationException {
        ConfigurationInfo info = this.getInfo(var);
        this.setPrerequisites(info.getPrerequisites(), var, done, config, true);
        this.setPrerequisites(info.getSoftPrerequisites(), var, done, config, false);
        if (this.committed.contains(var)) {
            return;
        }
        this.committed.add(var);
        done.add(var);
        assert (this.varMap.containsKey(var));
        List<ConfigurationValue> vals = this.varMap.get(var);
        if (vals.size() > 1) assert (info.allowMultiple());
        for (ConfigurationValue val : vals) {
            try {
                Object[] args = this.buildArgList(info, val);
                info.getSetterMethod().invoke(config, args);
            }
            catch (Exception e) {
                Throwable t = e;
                if (e instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)e).getTargetException();
                }
                if (Trace.error) {
                    t.printStackTrace();
                }
                if (t instanceof ConfigurationException) {
                    throw (ConfigurationException)t;
                }
                throw new ConfigurationException.OtherThrowable(t, var, val.getSource(), val.getLine());
            }
        }
    }

    private void setPrerequisites(String[] prerequisites, String var, Set<String> done, Object config, boolean required) throws ConfigurationException {
        if (prerequisites != null) {
            for (int p = 0; p < prerequisites.length; ++p) {
                String car;
                String newDepvar;
                String depvar = prerequisites[p];
                int dot = var.lastIndexOf(46);
                if (dot >= 0 && (this.isValidVar(newDepvar = (car = var.substring(0, dot)) + "." + depvar) || !this.isValidVar(depvar))) {
                    depvar = newDepvar;
                }
                if (done.contains(depvar)) continue;
                if (!this.isValidVar(depvar)) {
                    assert (false) : "invalid " + var + " dependency " + depvar;
                    continue;
                }
                if (this.varMap.containsKey(depvar)) {
                    this.commitVariable(config, depvar, done);
                    continue;
                }
                if (!required || this.committed.contains(depvar)) continue;
                throw new ConfigurationException.MissingRequirement(depvar, var, null, -1);
            }
        }
    }

    private String[] constructStringArray(List<String> args) {
        String[] sa = new String[args.size()];
        int i = 0;
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            sa[i++] = it.next();
        }
        return sa;
    }

    private Object constructValueObject(ConfigurationInfo info, ConfigurationValue cv) throws ConfigurationException {
        try {
            Class<?>[] pt = info.getSetterMethod().getParameterTypes();
            assert (pt.length == 2);
            Object o = pt[1].newInstance();
            Field[] fields = pt[1].getFields();
            assert (fields.length == cv.getArgs().size());
            Iterator<String> argsit = cv.getArgs().iterator();
            for (int f = 0; f < fields.length; ++f) {
                String val = argsit.next();
                Object valobj = null;
                Class<?> fc = fields[f].getType();
                assert (info.getArgType(f) == fc);
                assert (info.getArgName(f).equals(ConfigurationBuffer.c2h(fields[f].getName())));
                if (fc == String.class) {
                    valobj = val;
                } else if (fc == Boolean.class || fc == Boolean.TYPE) {
                    valobj = Boolean.valueOf(val);
                } else if (fc == Integer.class || fc == Integer.TYPE) {
                    valobj = Integer.decode(val);
                } else if (fc == Long.class || fc == Long.TYPE) {
                    valobj = Long.decode(val);
                } else assert (false);
                fields[f].set(o, valobj);
            }
            return o;
        }
        catch (InstantiationException e) {
            assert (false) : "coding error: unable to instantiate value object when trying to set var " + cv.getVar();
            throw new ConfigurationException.OtherThrowable(e, cv.getVar(), cv.getSource(), cv.getLine());
        }
        catch (IllegalAccessException e) {
            assert (false) : "coding error: " + e + " when trying to set var " + cv.getVar();
            throw new ConfigurationException.OtherThrowable(e, cv.getVar(), cv.getSource(), cv.getLine());
        }
    }

    protected static boolean isSupportedSimpleType(Class<?> c) {
        return c == String.class || c == Integer.class || c == Integer.TYPE || c == Long.class || c == Long.TYPE || c == Boolean.class || c == Boolean.TYPE;
    }

    protected static boolean isSupportedListType(Class<?> c) {
        return c == List.class || c == String[].class;
    }

    protected static boolean isSupportedValueType(Class<?> c) {
        if (ConfigurationBuffer.isSupportedSimpleType(c)) {
            return false;
        }
        Field[] fields = c.getFields();
        for (int f = 0; f < fields.length; ++f) {
            if (ConfigurationBuffer.isSupportedSimpleType(fields[f].getType())) continue;
            return false;
        }
        return true;
    }

    private Object[] buildArgList(ConfigurationInfo info, ConfigurationValue val) throws ConfigurationException {
        Method setter = info.getSetterMethod();
        Class<?>[] pt = setter.getParameterTypes();
        List<String> args = this.processValues(val.getVar(), val.getArgs(), val.getSource(), val.getLine());
        if (info.getArgCount() == -1) {
            if (pt.length != 2) {
                assert (false) : "coding error: unlimited length setter " + val.getVar() + " must take a single argument of type List or String[]";
                return null;
            }
            if (List.class.isAssignableFrom(pt[1])) {
                return new Object[]{val, args};
            }
            if (String[].class.isAssignableFrom(pt[1])) {
                return new Object[]{val, this.constructStringArray(args)};
            }
            assert (false) : "coding error: unlimited length setter " + val.getVar() + " must take a single argument of type List or String[]";
            return null;
        }
        assert (pt.length > 1) : "coding error: config setter " + val.getVar() + " must accept at least one argument";
        if (pt.length == 2) {
            if (List.class.isAssignableFrom(pt[1])) {
                return new Object[]{val, args};
            }
            if (String[].class == pt[1]) {
                return new Object[]{val, this.constructStringArray(args)};
            }
            if (ConfigurationBuffer.isSupportedValueType(pt[1])) {
                return new Object[]{val, this.constructValueObject(info, val)};
            }
        }
        assert (pt.length == args.size() + 1) : "coding error: config setter " + val.getVar() + " does not have " + args.size() + " parameters!";
        Object[] pa = new Object[pt.length];
        pa[0] = val;
        for (int p = 1; p < pt.length; ++p) {
            String arg = args.get(p - 1);
            if (pt[p].isAssignableFrom(String.class)) {
                pa[p] = arg;
                continue;
            }
            if (pt[p] == Integer.TYPE || pt[p] == Integer.class) {
                try {
                    pa[p] = Integer.decode(arg);
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException.TypeMismatch("Integer", arg, val.getVar(), val.getSource(), val.getLine());
                }
            }
            if (pt[p] == Long.TYPE || pt[p] == Long.class) {
                try {
                    pa[p] = Long.decode(arg);
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException.TypeMismatch("Long", arg, val.getVar(), val.getSource(), val.getLine());
                }
            }
            if (pt[p] == Boolean.TYPE || pt[p] == Boolean.class) {
                try {
                    arg = arg.trim().toLowerCase();
                    if (!arg.equals("true") && !arg.equals("false")) {
                        throw new ConfigurationException.TypeMismatch("Boolean", arg, val.getVar(), val.getSource(), val.getLine());
                    }
                    pa[p] = Boolean.valueOf(arg);
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException.TypeMismatch("Boolean", arg, val.getVar(), val.getSource(), val.getLine());
                }
            }
            assert (false) : "coding error: " + val.getVar() + " setter argument " + p + " is not a supported type";
        }
        return pa;
    }

    public void addAlias(String alias, String var) {
        if (!this.isValidVar(var)) {
            assert (false) : "coding error: can't bind alias " + alias + " to nonexistent var " + var;
            return;
        }
        if (this.aliases.containsKey(alias)) {
            assert (false) : "coding error: alias " + alias + " already defined as " + this.aliases.get(alias);
            return;
        }
        if (this.varCache.containsKey(alias)) {
            assert (false) : "coding error: can't define alias " + alias + ", it already exists as a var";
            return;
        }
        this.aliases.put(alias, var);
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public String unalias(String var) {
        String realvar = this.aliases.get(var);
        return realvar == null ? var : realvar;
    }

    public String peekSimpleConfigurationVar(String avar) throws ConfigurationException {
        String val = null;
        List<ConfigurationValue> valList = this.getVar(avar);
        if (valList != null) {
            ConfigurationValue cv = valList.get(0);
            List<String> args = this.processValues(avar, cv.getArgs(), cv.getSource(), cv.getLine());
            val = args.get(0);
        }
        return val;
    }

    public List<ConfigurationValue> peekConfigurationVar(String avar) throws ConfigurationException {
        List<ConfigurationValue> srcList = this.getVar(avar);
        if (srcList == null) {
            return null;
        }
        LinkedList<ConfigurationValue> dstList = new LinkedList<ConfigurationValue>();
        for (ConfigurationValue srcVal : srcList) {
            List<String> args = this.processValues(avar, srcVal.getArgs(), srcVal.getSource(), srcVal.getLine());
            ConfigurationValue dstVal = new ConfigurationValue(srcVal.getBuffer(), avar, args, srcVal.getSource(), srcVal.getLine(), srcVal.getContext());
            dstList.add(dstVal);
        }
        return dstList;
    }

    public void addPosition(String var, int iStart, int iEnd) {
        this.positions.add(new Object[]{var, new Integer(iStart), new Integer(iEnd)});
    }

    public List<Object[]> getPositions() {
        return this.positions;
    }

    public static List<String> formatText(String input, int columns) {
        ArrayList<String> lines;
        block15: {
            lines = new ArrayList<String>();
            if (input == null || input.length() == 0) {
                return lines;
            }
            int current = 0;
            int lineStart = -1;
            int lineEnd = -1;
            int wordStart = -1;
            int wordEnd = -1;
            boolean start = true;
            boolean preserve = true;
            while (current < input.length()) {
                boolean printable;
                boolean newline = input.charAt(current) == '\n';
                boolean bl = printable = preserve && !newline || !Character.isWhitespace(input.charAt(current));
                if (start) {
                    if (printable) {
                        if (lineStart == -1) {
                            lineStart = current;
                        }
                        wordStart = current;
                        start = false;
                        continue;
                    }
                    if (newline && lineStart != -1) {
                        lines.add(input.substring(lineStart, current));
                        lineStart = -1;
                    } else if (newline) {
                        lines.add("");
                    }
                    ++current;
                    continue;
                }
                preserve = false;
                if (printable) {
                    ++current;
                    continue;
                }
                wordEnd = current;
                if (lineEnd == -1) {
                    lineEnd = current;
                }
                if (wordEnd - lineStart < columns) {
                    if (newline) {
                        lines.add(input.substring(lineStart, current));
                        lineStart = -1;
                        lineEnd = -1;
                        wordStart = -1;
                        start = true;
                        preserve = true;
                        ++current;
                        continue;
                    }
                    start = true;
                    lineEnd = current;
                    continue;
                }
                lines.add(input.substring(lineStart, lineEnd));
                lineStart = wordStart;
                lineEnd = -1;
                wordStart = -1;
                start = true;
                if (!newline) continue;
                preserve = true;
            }
            if (lineStart == -1) break block15;
            wordEnd = current;
            if (lineEnd == -1) {
                lineEnd = current;
            }
            if (wordEnd - lineStart < columns || wordEnd == lineEnd) {
                lineEnd = wordEnd;
                lines.add(input.substring(lineStart, wordEnd));
            } else {
                lines.add(input.substring(lineStart, lineEnd));
                lines.add(input.substring(wordStart, wordEnd));
            }
        }
        return lines;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Object[] variables = this.varMap.keySet().toArray(new String[0]);
        Arrays.sort(variables);
        for (Object var : variables) {
            sb.append((String)var);
            sb.append("=");
            ArrayList<String> commaSeparatedValues = new ArrayList<String>();
            for (ConfigurationValue cv : this.varMap.get(var)) {
                List<String> args = cv.getArgs();
                String joinedArgs = Joiner.on((char)',').join(args);
                commaSeparatedValues.add(joinedArgs);
            }
            String rhs = Joiner.on((char)';').join(commaSeparatedValues);
            sb.append(rhs);
            sb.append('\n');
        }
        return sb.toString();
    }
}

