/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.upnp.internal;

class Hex {
    private Hex() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String encode(byte[] data) {
        StringBuffer sb;
        if (data == null) {
            return "null";
        }
        StringBuffer stringBuffer = sb = new StringBuffer(data.length * 3);
        synchronized (stringBuffer) {
            for (int i = 0; i < data.length; ++i) {
                sb.append(Integer.toHexString(data[i] & 0xFF)).append('-');
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
    }

    public static final byte[] decode(String input) throws IllegalArgumentException {
        char[] chars = input.toCharArray();
        byte[] tmp = new byte[1 + chars.length / 2];
        int length = 0;
        int current = 0;
        int hexCharatersCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            char ch = Character.toUpperCase(chars[i]);
            switch (ch) {
                case '-': {
                    tmp[length++] = (byte)current;
                    hexCharatersCount = 0;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    if (++hexCharatersCount > 2) {
                        throw new IllegalArgumentException("Illegal block detected @ " + i + ", data = " + input);
                    }
                    if (hexCharatersCount == 1) {
                        current = Hex.toHex(ch);
                        break;
                    }
                    current = current << 4 | Hex.toHex(ch);
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal character encoding @ " + i + ", char: " + ch);
                }
            }
            if (hexCharatersCount <= 0) continue;
            tmp[length] = (byte)current;
        }
        byte[] ret = new byte[length + 1];
        System.arraycopy(tmp, 0, ret, 0, length + 1);
        return ret;
    }

    private static final int toHex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Illegal character: " + ch);
    }
}

