/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.Enumeration;
import org.apache.felix.log.LogEntryImpl;
import org.apache.felix.log.LogListenerThread;
import org.apache.felix.log.LogNode;
import org.apache.felix.log.LogNodeEnumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;

final class Log
implements BundleListener,
FrameworkListener,
ServiceListener {
    private volatile LogNode m_head;
    private volatile LogNode m_tail;
    private volatile int m_size;
    private volatile LogListenerThread listenerThread;
    private final int m_maxSize;
    private final boolean m_storeDebug;
    private volatile boolean active = true;
    private static final String[] FRAMEWORK_EVENT_MESSAGES = new String[]{"FrameworkEvent STARTED", "FrameworkEvent ERROR", "FrameworkEvent PACKAGES REFRESHED", "FrameworkEvent STARTLEVEL CHANGED", "FrameworkEvent WARNING", "FrameworkEvent INFO"};
    private static final String[] BUNDLE_EVENT_MESSAGES = new String[]{"BundleEvent INSTALLED", "BundleEvent STARTED", "BundleEvent STOPPED", "BundleEvent UPDATED", "BundleEvent UNINSTALLED", "BundleEvent RESOLVED", "BundleEvent UNRESOLVED", "BundleEvent STARTING", "BundleEvent STOPPING", "BundleEvent LAZY_ACTIVATION"};
    private static final String[] SERVICE_EVENT_MESSAGES = new String[]{"ServiceEvent REGISTERED", "ServiceEvent MODIFIED", "ServiceEvent UNREGISTERING"};

    Log(int maxSize, boolean storeDebug) {
        this.m_maxSize = maxSize;
        this.m_storeDebug = storeDebug;
    }

    synchronized void close() {
        this.active = false;
        if (this.listenerThread != null) {
            this.listenerThread.shutdown();
            this.listenerThread = null;
        }
        this.m_head = null;
        this.m_tail = null;
        this.m_size = 0;
    }

    void log(String name, Bundle bundle, ServiceReference<?> sr, LogLevel level, String message, Throwable exception) {
        this.addEntry(new LogEntryImpl(name, bundle, sr, level, message, exception, Log.getStackTraceElement()));
    }

    synchronized void addEntry(LogEntry entry) {
        if (!this.active) {
            return;
        }
        if (this.m_maxSize != 0) {
            if (this.m_storeDebug || entry.getLogLevel() != LogLevel.DEBUG) {
                LogNode node = new LogNode(entry);
                node.setNextNode(this.m_head);
                if (this.m_head != null) {
                    this.m_head.setPreviousNode(node);
                }
                this.m_head = node;
                ++this.m_size;
                if (this.m_tail == null) {
                    this.m_tail = node;
                }
            }
            if (this.m_maxSize != -1 && this.m_size > this.m_maxSize) {
                LogNode last = this.m_tail.getPreviousNode();
                last.setNextNode(null);
                this.m_tail = last;
                --this.m_size;
            }
        }
        if (this.listenerThread != null) {
            this.listenerThread.addEntry(entry);
        }
    }

    synchronized void addListener(LogListener listener) {
        if (this.active) {
            if (this.listenerThread == null) {
                this.listenerThread = new LogListenerThread();
                this.listenerThread.start();
            }
            this.listenerThread.addListener(listener);
        }
    }

    synchronized void removeListener(LogListener listener) {
        if (this.listenerThread != null) {
            this.listenerThread.removeListener(listener);
            if (this.listenerThread.getListenerCount() == 0) {
                this.listenerThread.shutdown();
                this.listenerThread = null;
            }
        }
    }

    synchronized Enumeration<LogEntry> getEntries() {
        return new LogNodeEnumeration(this.m_head, this.m_tail);
    }

    public void frameworkEvent(FrameworkEvent event) {
        int eventType = event.getType();
        String message = null;
        for (int i = 0; message == null && i < FRAMEWORK_EVENT_MESSAGES.length; ++i) {
            if (eventType >> i != 1) continue;
            message = FRAMEWORK_EVENT_MESSAGES[i];
        }
        this.log("Events.Framework.".concat(event.getBundle().getSymbolicName()), event.getBundle(), null, eventType == 2 ? LogLevel.ERROR : LogLevel.INFO, message, event.getThrowable());
    }

    public void bundleChanged(BundleEvent event) {
        int eventType = event.getType();
        String message = null;
        for (int i = 0; message == null && i < BUNDLE_EVENT_MESSAGES.length; ++i) {
            if (eventType >> i != 1) continue;
            message = BUNDLE_EVENT_MESSAGES[i];
        }
        if (message != null) {
            this.log("Events.Bundle.".concat(event.getBundle().getSymbolicName()), event.getBundle(), null, LogLevel.INFO, message, null);
        }
    }

    public static StackTraceElement getStackTraceElement() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements.length == 0) {
            return null;
        }
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i].getClassName().startsWith("org.apache.felix.log")) continue;
            return elements[i];
        }
        return elements[1];
    }

    public void serviceChanged(ServiceEvent event) {
        int eventType = event.getType();
        String message = null;
        for (int i = 0; message == null && i < SERVICE_EVENT_MESSAGES.length; ++i) {
            if (eventType >> i != 1) continue;
            message = SERVICE_EVENT_MESSAGES[i];
        }
        this.log("Events.Service.".concat(event.getServiceReference().getBundle().getSymbolicName()), event.getServiceReference().getBundle(), event.getServiceReference(), eventType == 2 ? LogLevel.DEBUG : LogLevel.INFO, message, null);
    }
}

