/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.servlet.HttpConstants;
import org.osgi.service.http.HttpContext;

public class ServletContextImpl
implements ServletContext {
    private final HttpContext m_httpContext;
    private final Logger m_logger;
    private final Dictionary m_initparams;
    private Map m_attributes;
    private final String m_name;

    public ServletContextImpl(String name, HttpContext httpContext, Dictionary initparams, Logger logger) {
        this.m_name = name;
        this.m_httpContext = httpContext;
        this.m_initparams = initparams;
        this.m_logger = logger;
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String file) {
        return this.m_httpContext.getMimeType(file);
    }

    public Set getResourcePaths(String path) {
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.m_httpContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.m_httpContext.getResource(path).openStream();
        }
        catch (IOException e) {
            this.m_logger.log(1, "Unable to open stream on resource: " + path, e);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration getServlets() {
        return null;
    }

    public Enumeration getServletNames() {
        return null;
    }

    public void log(String msg) {
        this.m_logger.log(3, msg);
    }

    public void log(Exception exception, String msg) {
        this.m_logger.log(1, msg, exception);
    }

    public void log(String message, Throwable throwable) {
        this.m_logger.log(1, message, throwable);
    }

    public String getRealPath(String path) {
        return path;
    }

    public String getServerInfo() {
        return "Apache Felix Lightweight HTTP Service";
    }

    public String getInitParameter(String name) {
        Object o;
        if (this.m_initparams != null && (o = this.m_initparams.get(name)) != null) {
            return o.toString();
        }
        return null;
    }

    public Enumeration getInitParameterNames() {
        if (this.m_initparams != null) {
            return this.m_initparams.keys();
        }
        return HttpConstants.EMPTY_ENUMERATION;
    }

    public Object getAttribute(String name) {
        if (this.m_attributes != null) {
            return this.m_attributes.get(name);
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        if (this.m_attributes != null) {
            return Collections.enumeration(this.m_attributes.keySet());
        }
        return HttpConstants.EMPTY_ENUMERATION;
    }

    public void setAttribute(String name, Object object) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(name, object);
    }

    public void removeAttribute(String name) {
        if (this.m_attributes != null) {
            this.m_attributes.remove(name);
        }
    }

    public String getServletContextName() {
        return this.m_name;
    }

    public String getContextPath() {
        return this.m_name;
    }
}

