/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view;

import java.util.List;
import org.apache.directory.studio.schemaeditor.view.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ViewUtils {
    public static final Color COLOR_BLACK = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().getSystemColor(2);
    public static final Color COLOR_RED = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().getSystemColor(3);

    public static String concateAliases(List<String> aliases) {
        StringBuffer sb = new StringBuffer();
        if (aliases.size() > 0) {
            sb.append(aliases.get(0));
            int i = 1;
            while (i < aliases.size()) {
                sb.append(", ");
                sb.append(aliases.get(i));
                ++i;
            }
        }
        return sb.toString();
    }

    public static boolean verifyName(String name) {
        return name.matches(Messages.getString("ViewUtils.AllowedCharacters"));
    }

    public static boolean displayErrorMessageDialog(String title, String message) {
        return ViewUtils.displayMessageDialog(1, title, message);
    }

    public static boolean displayWarningMessageDialog(String title, String message) {
        return ViewUtils.displayMessageDialog(4, title, message);
    }

    public static boolean displayInformationMessageDialog(String title, String message) {
        return ViewUtils.displayMessageDialog(2, title, message);
    }

    public static boolean displayQuestionMessageDialog(String title, String message) {
        return ViewUtils.displayMessageDialog(3, title, message);
    }

    private static boolean displayMessageDialog(int kind, String title, String message) {
        return MessageDialog.open((int)kind, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (int)0);
    }
}

