/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.aci.ACIItemParser;
import org.apache.directory.api.ldap.aci.UserClass;
import org.apache.directory.api.ldap.aci.UserFirstACIItem;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;
import org.apache.directory.studio.aciitemeditor.model.Messages;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.osgi.util.NLS;

public class UserClassWrapper {
    public static final Map<Class<? extends UserClass>, String> CLASS_TO_IDENTIFIER_MAP;
    public static final Map<Class<? extends UserClass>, String> CLASS_TO_DISPLAY_MAP;
    private static final String DUMMY = "{ identificationTag \"id1\", precedence 1, authenticationLevel simple, itemOrUserFirst userFirst: { userClasses  { #identifier# #values# }, userPermissions { { protectedItems { entry }, grantsAndDenials { grantRead } } } } }";
    private final Class<? extends UserClass> clazz;
    private final List<String> values;
    private final String valuePrefix;
    private final String valueSuffix;
    private final AbstractDialogStringValueEditor valueEditor;

    static {
        HashMap<Class, String> map = new HashMap<Class, String>();
        map.put(UserClass.AllUsers.class, "allUsers");
        map.put(UserClass.ThisEntry.class, "thisEntry");
        map.put(UserClass.ParentOfEntry.class, "parentOfEntry");
        map.put(UserClass.Name.class, "name");
        map.put(UserClass.UserGroup.class, "userGroup");
        map.put(UserClass.Subtree.class, "subtree");
        CLASS_TO_IDENTIFIER_MAP = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(UserClass.AllUsers.class, Messages.getString("UserClassWrapper.userClass.allUsers.label"));
        map.put(UserClass.ThisEntry.class, Messages.getString("UserClassWrapper.userClass.thisEntry.label"));
        map.put(UserClass.ParentOfEntry.class, Messages.getString("UserClassWrapper.userClass.parentOfEntry.label"));
        map.put(UserClass.Name.class, Messages.getString("UserClassWrapper.userClass.name.label"));
        map.put(UserClass.UserGroup.class, Messages.getString("UserClassWrapper.userClass.userGroup.label"));
        map.put(UserClass.Subtree.class, Messages.getString("UserClassWrapper.userClass.subtree.label"));
        CLASS_TO_DISPLAY_MAP = Collections.unmodifiableMap(map);
    }

    public UserClassWrapper(Class<? extends UserClass> clazz, String valuePrefix, String valueSuffix, AbstractDialogStringValueEditor valueEditor) {
        this.clazz = clazz;
        this.valuePrefix = valuePrefix;
        this.valueSuffix = valueSuffix;
        this.valueEditor = valueEditor;
        this.values = new ArrayList<String>();
    }

    public UserClass getUserClass() throws ParseException {
        String flatValue = this.getFlatValue();
        String spec = DUMMY;
        spec = spec.replaceAll("#identifier#", this.getIdentifier());
        spec = spec.replaceAll("#values#", flatValue);
        ACIItemParser parser = new ACIItemParser(null);
        UserFirstACIItem aci = null;
        try {
            aci = (UserFirstACIItem)parser.parse(spec);
        }
        catch (ParseException parseException) {
            String msg = NLS.bind((String)Messages.getString("UserClassWrapper.error.message"), (Object[])new String[]{this.getIdentifier(), flatValue});
            throw new ParseException(msg, 0);
        }
        return (UserClass)aci.getUserClasses().iterator().next();
    }

    public void setUserClass(UserClass userClass) {
        block5: {
            block6: {
                block4: {
                    assert (userClass.getClass() == this.getClazz());
                    this.values.clear();
                    if (userClass.getClass() != UserClass.Name.class) break block4;
                    UserClass.Name name = (UserClass.Name)userClass;
                    for (String jndiName : name.getNames()) {
                        this.values.add(jndiName);
                    }
                    break block5;
                }
                if (userClass.getClass() != UserClass.UserGroup.class) break block6;
                UserClass.UserGroup userGroups = (UserClass.UserGroup)userClass;
                for (String jndiName : userGroups.getNames()) {
                    this.values.add(jndiName);
                }
                break block5;
            }
            if (userClass.getClass() != UserClass.Subtree.class) break block5;
            UserClass.Subtree subtree = (UserClass.Subtree)userClass;
            for (SubtreeSpecification subtreeSpecification : subtree.getSubtreeSpecifications()) {
                StringBuilder buffer = new StringBuilder();
                subtreeSpecification.toString(buffer);
                this.values.add(buffer.toString());
            }
        }
    }

    public String toString() {
        String flatValue = this.getFlatValue();
        StringBuilder sb = new StringBuilder();
        if (flatValue.length() > 0) {
            flatValue = flatValue.replace('\r', ' ');
            flatValue = flatValue.replace('\n', ' ');
            if ((flatValue = ": " + flatValue).length() > 40) {
                String temp = flatValue;
                flatValue = temp.substring(0, 20);
                flatValue = String.valueOf(flatValue) + "...";
                flatValue = String.valueOf(flatValue) + temp.substring(temp.length() - 20, temp.length());
            }
        }
        return sb.append(this.getDisplayName()).append(' ').append(flatValue).toString();
    }

    private String getFlatValue() {
        if (this.valueEditor == null || this.values.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("{ ");
        boolean isFirst = true;
        for (String value : this.values) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(this.valuePrefix);
            buffer.append(value);
            buffer.append(this.valueSuffix);
        }
        buffer.append(" }");
        return buffer.toString();
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getDisplayName() {
        return CLASS_TO_DISPLAY_MAP.get(this.clazz);
    }

    public String getIdentifier() {
        return CLASS_TO_IDENTIFIER_MAP.get(this.clazz);
    }

    public Class<? extends UserClass> getClazz() {
        return this.clazz;
    }

    public boolean isEditable() {
        return this.valueEditor != null;
    }

    public AbstractDialogStringValueEditor getValueEditor() {
        return this.valueEditor;
    }
}

