/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.field;

import org.odftoolkit.odfdom.dom.element.text.TextConditionalTextElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.common.field.Field;
import org.w3c.dom.Node;

public class ConditionField
extends Field {
    private TextConditionalTextElement conditionalTextElement;
    private final boolean isHiddenTextField;

    ConditionField(OdfElement odfElement, String condition, String trueText, String falseText, boolean isHiddenTextField) {
        if (odfElement instanceof TextPElement) {
            this.conditionalTextElement = ((TextPElement)odfElement).newTextConditionalTextElement("ooow:" + condition, falseText, trueText);
        } else if (odfElement instanceof TextSpanElement) {
            this.conditionalTextElement = ((TextSpanElement)odfElement).newTextConditionalTextElement("ooow:" + condition, falseText, trueText);
        } else {
            TextPElement pElement = (TextPElement)((OdfFileDom)odfElement.getOwnerDocument()).newOdfElement(TextPElement.class);
            odfElement.appendChild((Node)pElement);
            this.conditionalTextElement = pElement.newTextConditionalTextElement("ooow:" + condition, falseText, trueText);
        }
        this.conditionalTextElement.setTextCurrentValueAttribute(Boolean.valueOf(true));
        this.isHiddenTextField = isHiddenTextField;
        Component.registerComponent(this, this.getOdfElement());
    }

    public void updateCondition(String condition) {
        this.conditionalTextElement.setTextConditionAttribute("ooow:" + condition);
    }

    public void updateTrueText(String text) {
        this.conditionalTextElement.setTextStringValueIfTrueAttribute(text);
    }

    public void updateFalseText(String text) {
        this.conditionalTextElement.setTextStringValueIfFalseAttribute(text);
    }

    public OdfElement getOdfElement() {
        return this.conditionalTextElement;
    }

    public Field.FieldType getFieldType() {
        return this.isHiddenTextField ? Field.FieldType.HIDDEN_TEXT_FIELD : Field.FieldType.CONDITION_FIELD;
    }
}

