/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import org.apache.derby.agg.Aggregator;

public class LobMode<V>
implements Aggregator<V, V, LobMode<V>> {
    private HashMap<String, Accumulator<V>> _accumulators;

    public void init() {
        this._accumulators = new HashMap();
    }

    public void accumulate(V value) {
        this.getAccumulator(value).add(1);
    }

    public void merge(LobMode<V> otherAggregator) {
        HashMap<String, Accumulator<V>> otherAccumulators = otherAggregator._accumulators;
        for (Accumulator<V> accumulator : otherAccumulators.values()) {
            V value = accumulator.getValue();
            this.getAccumulator(value).add(accumulator.getCount());
        }
    }

    public V terminate() {
        return this._accumulators.isEmpty() ? null : (V)Collections.max(this._accumulators.values()).getValue();
    }

    private Accumulator<V> getAccumulator(V value) {
        String key = LobMode.toString(value);
        Accumulator<V> retval = this._accumulators.get(key);
        if (retval == null) {
            retval = new Accumulator<V>(value);
            this._accumulators.put(key, retval);
        }
        return retval;
    }

    static String toString(Object raw) {
        try {
            if (raw instanceof Clob) {
                Clob clob = (Clob)raw;
                return clob.getSubString(1L, (int)clob.length());
            }
            if (raw instanceof Blob) {
                Blob blob = (Blob)raw;
                byte[] bytes = blob.getBytes(1L, (int)blob.length());
                return new String(bytes, "UTF-8");
            }
            if (raw instanceof Date) {
                return raw.toString();
            }
            if (raw instanceof Time) {
                return raw.toString();
            }
            if (raw instanceof Timestamp) {
                return raw.toString();
            }
            if (raw instanceof byte[]) {
                byte[] bytes = (byte[])raw;
                return new String(bytes, "UTF-8");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException("Unsupported object type: " + raw.getClass().getName());
    }

    public static final class Accumulator<V>
    implements Comparable<Accumulator<V>> {
        private V _value;
        private int _count;

        public Accumulator(V value) {
            this._value = value;
            this._count = 0;
        }

        public void add(int increment) {
            this._count += increment;
        }

        public V getValue() {
            return this._value;
        }

        public int getCount() {
            return this._count;
        }

        @Override
        public int compareTo(Accumulator<V> that) {
            int retval = this._count - that._count;
            if (retval != 0) {
                return retval;
            }
            return LobMode.toString(this._value).compareTo(LobMode.toString(that._value));
        }
    }

    public static final class TimestampMode
    extends LobMode<Timestamp> {
    }

    public static final class TimeMode
    extends LobMode<Time> {
    }

    public static final class DateMode
    extends LobMode<Date> {
    }

    public static final class BinaryMode
    extends LobMode<byte[]> {
    }

    public static final class BlobMode
    extends LobMode<Blob> {
    }

    public static final class ClobMode
    extends LobMode<Clob> {
    }
}

