/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowDescriptorBuilder {
    private static final Logger logger = LoggerFactory.getLogger(RowDescriptorBuilder.class);
    private static final Transformer UPPERCASE_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input.toString().toUpperCase() : null;
        }
    };
    private static final Transformer LOWERCASE_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input.toString().toLowerCase() : null;
        }
    };
    protected ColumnDescriptor[] columns;
    protected ResultSetMetaData resultSetMetadata;
    protected Transformer caseTransformer;
    protected Map<String, String> typeOverrides;
    protected boolean validateDuplicateColumnNames;

    public RowDescriptor getDescriptor(ExtendedTypeMap typeMap) throws SQLException, IllegalStateException {
        ColumnDescriptor[] columnsForRD;
        if (this.resultSetMetadata != null) {
            columnsForRD = this.mergeResultSetAndPresetColumns();
        } else if (this.columns != null) {
            columnsForRD = this.columns;
        } else {
            throw new IllegalStateException("Can't build RowDescriptor, both 'columns' and 'resultSetMetadata' are null");
        }
        this.performTransformAndTypeOverride(columnsForRD);
        ExtendedType[] converters = new ExtendedType[columnsForRD.length];
        for (int i = 0; i < columnsForRD.length; ++i) {
            converters[i] = typeMap.getRegisteredType(columnsForRD[i].getJavaClass());
        }
        return new RowDescriptor(columnsForRD, converters);
    }

    protected ColumnDescriptor[] mergeResultSetAndPresetColumns() throws SQLException {
        int columnLen;
        int rsLen = this.resultSetMetadata.getColumnCount();
        if (rsLen == 0) {
            throw new CayenneRuntimeException("'ResultSetMetadata' is empty.", new Object[0]);
        }
        int n = columnLen = this.columns != null ? this.columns.length : 0;
        if (rsLen < columnLen) {
            throw new CayenneRuntimeException("'ResultSetMetadata' has less elements then 'columns'.", new Object[0]);
        }
        if (rsLen == columnLen) {
            return this.columns;
        }
        ColumnDescriptor[] rsColumns = new ColumnDescriptor[rsLen];
        ArrayList<String> duplicates = null;
        HashSet<String> uniqueNames = null;
        if (this.validateDuplicateColumnNames) {
            duplicates = new ArrayList<String>();
            uniqueNames = new HashSet<String>();
        }
        int outputLen = 0;
        for (int i = 0; i < rsLen; ++i) {
            String rowkey = this.resolveDataRowKeyFromResultSet(i + 1);
            ColumnDescriptor descriptor = this.getColumnDescriptor(rowkey, this.columns, i + 1);
            if (this.validateDuplicateColumnNames && !uniqueNames.add(descriptor.getDataRowKey())) {
                duplicates.add(descriptor.getDataRowKey());
            }
            rsColumns[outputLen] = descriptor;
            ++outputLen;
        }
        if (this.validateDuplicateColumnNames && !duplicates.isEmpty()) {
            logger.warn("Found duplicated columns '" + StringUtils.join(duplicates, (String)"', '") + "' in row descriptor. This can lead to errors when converting result to persistent objects.");
        }
        if (outputLen < rsLen) {
            ColumnDescriptor[] rsColumnsCut = new ColumnDescriptor[outputLen];
            System.arraycopy(rsColumns, 0, rsColumnsCut, 0, outputLen);
            return rsColumnsCut;
        }
        return rsColumns;
    }

    private ColumnDescriptor getColumnDescriptor(String rowKey, ColumnDescriptor[] columnArray, int position) throws SQLException {
        int len = columnArray != null ? columnArray.length : 0;
        for (int i = 0; i < len; ++i) {
            String columnRowKey;
            if (columnArray[i] == null || (columnRowKey = columnArray[i].getDataRowKey()) == null || !columnRowKey.equalsIgnoreCase(rowKey)) continue;
            return columnArray[i];
        }
        return new ColumnDescriptor(rowKey, this.resultSetMetadata, position);
    }

    private String resolveDataRowKeyFromResultSet(int position) throws SQLException {
        String name = this.resultSetMetadata.getColumnLabel(position);
        if ((name == null || name.length() == 0) && (name = this.resultSetMetadata.getColumnName(position)) == null) {
            name = "";
        }
        return name;
    }

    private void performTransformAndTypeOverride(ColumnDescriptor[] columnArray) {
        int len = columnArray.length;
        if (this.caseTransformer != null) {
            for (ColumnDescriptor aColumnArray : columnArray) {
                aColumnArray.setDataRowKey((String)this.caseTransformer.transform((Object)aColumnArray.getDataRowKey()));
                aColumnArray.setName((String)this.caseTransformer.transform((Object)aColumnArray.getName()));
            }
        }
        if (this.typeOverrides != null) {
            for (ColumnDescriptor aColumnArray : columnArray) {
                String type = this.typeOverrides.get(aColumnArray.getName());
                if (type == null) continue;
                aColumnArray.setJavaClass(type);
            }
        }
    }

    public RowDescriptorBuilder setColumns(ColumnDescriptor[] columns) {
        this.columns = columns;
        return this;
    }

    public RowDescriptorBuilder setResultSet(ResultSet resultSet) throws SQLException {
        this.resultSetMetadata = resultSet.getMetaData();
        return this;
    }

    public RowDescriptorBuilder useLowercaseColumnNames() {
        this.caseTransformer = LOWERCASE_TRANSFORMER;
        return this;
    }

    public RowDescriptorBuilder useUppercaseColumnNames() {
        this.caseTransformer = UPPERCASE_TRANSFORMER;
        return this;
    }

    public RowDescriptorBuilder overrideColumnType(String columnName, String type) {
        if (this.typeOverrides == null) {
            this.typeOverrides = new HashMap<String, String>();
        }
        this.typeOverrides.put(columnName, type);
        return this;
    }

    public RowDescriptorBuilder validateDuplicateColumnNames() {
        this.validateDuplicateColumnNames = true;
        return this;
    }

    public boolean isOverriden(String columnName) {
        return this.typeOverrides != null && this.typeOverrides.containsKey(columnName);
    }
}

