/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.url;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;
import org.apache.aries.jndi.url.BlueprintName;
import org.apache.aries.jndi.url.BlueprintNameParser;
import org.apache.aries.util.nls.MessageUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintURLContext
implements Context {
    private static final String BLUEPRINT_NAMESPACE = "blueprint:comp/";
    private Bundle _callersBundle;
    private Map<String, Object> _env;
    private NameParser _parser = new BlueprintNameParser();
    private BlueprintName _parentName;
    private static final MessageUtil MESSAGES = MessageUtil.createMessageUtil(BlueprintURLContext.class, (String)"org.apache.aries.jndi.nls.jndiUrlMessages");
    static final Pattern graceP = Pattern.compile(".*;\\s*blueprint.graceperiod\\s*:=\\s*\"?([A-Za-z]+).*");
    static final Pattern timeoutP = Pattern.compile(".*;\\s*blueprint.timeout\\s*:=\\s*\"?([0-9]+).*");

    public BlueprintURLContext(Bundle callersBundle, Hashtable<?, ?> env) {
        this._callersBundle = callersBundle;
        this._env = new HashMap<String, Object>();
        this._env.putAll(env);
        this._parentName = null;
    }

    private BlueprintURLContext(Bundle callersBundle, BlueprintName parentName, Map<String, Object> env) {
        this._callersBundle = callersBundle;
        this._parentName = parentName;
        this._env = env;
    }

    protected void finalize() throws NamingException {
        this.close();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this._env.put(propName, propVal);
    }

    @Override
    public void bind(Name n, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void close() throws NamingException {
        this._env = null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        String ns;
        String result = prefix + "/" + name;
        if (result.startsWith(ns = BLUEPRINT_NAMESPACE)) {
            ns = "";
        }
        return this._parser.parse(ns + result);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        String ns;
        String result = prefix + "/" + name;
        if (result.startsWith(ns = BLUEPRINT_NAMESPACE)) {
            ns = "";
        }
        this._parser.parse(ns + result);
        return result;
    }

    @Override
    public Context createSubcontext(Name n) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name n) throws NamingException {
    }

    @Override
    public void destroySubcontext(String s) throws NamingException {
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        Hashtable<String, Object> environment = new Hashtable<String, Object>();
        environment.putAll(this._env);
        return environment;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NameParser getNameParser(Name n) throws NamingException {
        return this._parser;
    }

    @Override
    public NameParser getNameParser(String s) throws NamingException {
        return this._parser;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String s) throws NamingException {
        BlueprintComponentNamingEnumeration<NameClassPair> result = new BlueprintComponentNamingEnumeration<NameClassPair>(this._callersBundle, new ComponentProcessor<NameClassPair>(){

            @Override
            public NameClassPair get(Binding b) {
                NameClassPair result = new NameClassPair(b.getName(), b.getClassName());
                return result;
            }
        });
        return result;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        BlueprintComponentNamingEnumeration<Binding> result = new BlueprintComponentNamingEnumeration<Binding>(this._callersBundle, new ComponentProcessor<Binding>(){

            @Override
            public Binding get(Binding b) {
                return b;
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(Name name) throws NamingException, ServiceUnavailableException {
        Object result;
        block6: {
            ServiceReference blueprintContainerRef = BlueprintURLContext.getBlueprintContainerRef(this._callersBundle);
            try {
                BlueprintContainer blueprintContainer = (BlueprintContainer)this._callersBundle.getBundleContext().getService(blueprintContainerRef);
                BlueprintName bpName = name instanceof BlueprintName ? (BlueprintName)name : (this._parentName != null ? new BlueprintName(this._parentName.toString() + "/" + name.toString()) : (BlueprintName)this._parser.parse(name.toString()));
                if (bpName.hasComponent()) {
                    String componentId = bpName.getComponentId();
                    try {
                        result = blueprintContainer.getComponentInstance(componentId);
                        break block6;
                    }
                    catch (NoSuchComponentException nsce) {
                        throw new NameNotFoundException(nsce.getMessage());
                    }
                }
                result = new BlueprintURLContext(this._callersBundle, bpName, this._env);
            }
            finally {
                this._callersBundle.getBundleContext().ungetService(blueprintContainerRef);
            }
        }
        return result;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (this._parentName != null) {
            name = this._parentName.toString() + "/" + name;
        }
        Object result = this.lookup(this._parser.parse(name));
        return result;
    }

    @Override
    public Object lookupLink(Name n) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(Name n, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(String s, Object o) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this._env.remove(propName);
    }

    @Override
    public void rename(Name nOld, Name nNew) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String sOld, String sNew) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(Name n) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(String s) throws NamingException {
        throw new OperationNotSupportedException();
    }

    private static ServiceReference findBPCRef(Bundle b) {
        ServiceReference[] refs = b.getRegisteredServices();
        ServiceReference result = null;
        if (refs != null) {
            block0: for (ServiceReference r : refs) {
                String[] objectClasses;
                for (String objectClass : objectClasses = (String[])r.getProperty("objectClass")) {
                    if (!objectClass.equals(BlueprintContainer.class.getName())) continue;
                    result = r;
                    break block0;
                }
            }
        }
        return result;
    }

    private static ServiceReference getBlueprintContainerRef(Bundle b) throws ServiceUnavailableException {
        ServiceReference result = BlueprintURLContext.findBPCRef(b);
        if (result == null) {
            Semaphore s = new Semaphore(0);
            AtomicReference<ServiceReference> bpcRef = new AtomicReference<ServiceReference>();
            ServiceTracker st = new ServiceTracker(b.getBundleContext(), BlueprintContainer.class.getName(), (ServiceTrackerCustomizer)new BlueprintContainerServiceTrackerCustomizer(b, s, bpcRef));
            st.open();
            int graceperiod = BlueprintURLContext.getGracePeriod(b);
            result = BlueprintURLContext.findBPCRef(b);
            if (result == null && graceperiod >= 0) {
                if (graceperiod == 0) {
                    try {
                        s.acquire();
                    }
                    catch (InterruptedException ix) {}
                } else {
                    try {
                        s.tryAcquire(graceperiod, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ix) {
                        // empty catch block
                    }
                }
            }
            result = bpcRef.get();
            st.close();
        }
        if (result == null) {
            throw new ServiceUnavailableException(MESSAGES.getMessage("no.blueprint.container", new Object[]{b.getSymbolicName() + '/' + b.getVersion()}));
        }
        return result;
    }

    public static int getGracePeriod(Bundle b) {
        int result = 300000;
        boolean gracePeriodSet = true;
        String bundleSymbolicName = (String)b.getHeaders().get("Bundle-SymbolicName");
        Matcher m = graceP.matcher(bundleSymbolicName);
        if (m.matches()) {
            String gracePeriod = m.group(1);
            boolean bl = gracePeriodSet = !gracePeriod.equalsIgnoreCase("false");
        }
        if (!gracePeriodSet) {
            result = -1;
        } else {
            m = timeoutP.matcher(bundleSymbolicName);
            if (m.matches()) {
                String timeout = m.group(1);
                try {
                    result = Integer.valueOf(timeout);
                }
                catch (NumberFormatException nfx) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlueprintContainerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer {
        Bundle bundleToFindBPCServiceIn = null;
        Semaphore semaphore;
        AtomicReference<ServiceReference> atomicRef = null;

        public BlueprintContainerServiceTrackerCustomizer(Bundle b, Semaphore s, AtomicReference<ServiceReference> aref) {
            this.bundleToFindBPCServiceIn = b;
            this.semaphore = s;
            this.atomicRef = aref;
        }

        public Object addingService(ServiceReference reference) {
            Object result = null;
            if (this.bundleToFindBPCServiceIn.equals(reference.getBundle())) {
                this.atomicRef.set(reference);
                this.semaphore.release();
                result = reference.getBundle().getBundleContext().getService(reference);
            }
            return result;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlueprintComponentNamingEnumeration<T>
    implements NamingEnumeration<T> {
        private Binding[] blueprintIdToComponentBindings;
        private int position = 0;
        private ComponentProcessor<T> processor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BlueprintComponentNamingEnumeration(Bundle callersBundle, ComponentProcessor<T> p) throws ServiceUnavailableException {
            ServiceReference blueprintContainerRef = BlueprintURLContext.getBlueprintContainerRef(callersBundle);
            try {
                BlueprintContainer blueprintContainer = (BlueprintContainer)callersBundle.getBundleContext().getService(blueprintContainerRef);
                Set componentIds = blueprintContainer.getComponentIds();
                this.blueprintIdToComponentBindings = new Binding[componentIds.size()];
                Iterator idIterator = componentIds.iterator();
                for (int i = 0; i < this.blueprintIdToComponentBindings.length; ++i) {
                    String id = (String)idIterator.next();
                    Object o = blueprintContainer.getComponentInstance(id);
                    this.blueprintIdToComponentBindings[i] = new Binding(id, o);
                }
                this.processor = p;
            }
            finally {
                callersBundle.getBundleContext().ungetService(blueprintContainerRef);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.position < this.blueprintIdToComponentBindings.length;
        }

        @Override
        public T nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            Binding bindingToProcess = this.blueprintIdToComponentBindings[this.position];
            ++this.position;
            T result = this.processor.get(bindingToProcess);
            return result;
        }

        @Override
        public T next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public void close() throws NamingException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ComponentProcessor<T> {
        public T get(Binding var1);
    }
}

